#include "dit_id.h"
#include "md5.h"

namespace NIdentifiers {
    bool TDitId::Validate(const TString& value) {
        return RE2::FullMatch(value, MD5_REGEXP);
    }

    TString TDitId::Next() {
        return TMd5::Next();
    }

    NCrypta::NIdentifiersProto::TGenericID TDitId::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            auto proto_big_int = HexToUInt128(Normalize());
            proto.MutableDitId()->MutableValue()->SetLo(proto_big_int.GetLo());
            proto.MutableDitId()->MutableValue()->SetHi(proto_big_int.GetHi());
        }
        return proto;
    }

    TString TDitId::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : UIntToHex(proto.GetDitId().GetValue());
    }
}
