#pragma once

#include "yandexuid.h"
#include <crypta/lib/native/identifiers/lib/identifier.h>

namespace NIdentifiers {
    class TDuid: public TCookieMixin, public TTypedIdentifier<TDuid, NCrypta::NIdentifiersProto::NIdType::DUID> {
    public:
        using TTypedIdentifier::TTypedIdentifier;
        using TCookieMixin::GetMaxTimestamp;
        using TCookieMixin::GenerateRandomTimestamp;

        NCrypta::NIdentifiersProto::TGenericID ToProto() const override;
        static TString FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto);

        static ui64 GetTimestamp(const TString&);
        static ui64 GetTimestamp(ui64);
        ui64 GetTimestamp() const;

        static TString Next();

        static bool Validate(const TString&);
        static bool Validate(const ui64);
        static bool Significate(const TString&);
        static bool Significate(const ui64);

        const static size_t MinimalSigninficantSize{17};
    };
}
