#include "edadeal_uid.h"

namespace NIdentifiers {
    bool TEdadealUid::Validate(const TString& value) {
        return RE2::FullMatch(value, EDADEAL_GUID_REGEXP);
    }

    TString TEdadealUid::Next() {
        TString output;
        for (size_t index = 0; index < 32; ++index) {
            output.append(NextHexDigest());
        }
        return HexDigestDashes(output);
    }

    TString TEdadealUid::DoNormalize() const {
        TString normalized = Original;
        normalized.to_lower();
        if (RE2::FullMatch(normalized, EDADEAL_GUID_UNNORMALIZE_REGEXP)) {
            normalized = HexDigestDashes(normalized);
        }
        return normalized;
    }

    NCrypta::NIdentifiersProto::TGenericID TEdadealUid::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            auto proto_big_int = HexToUInt128(Normalize());
            proto.MutableEdadealUid()->MutableValue()->SetLo(proto_big_int.GetLo());
            proto.MutableEdadealUid()->MutableValue()->SetHi(proto_big_int.GetHi());
        }
        return proto;
    }

    TString TEdadealUid::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : HexDigestDashes(UIntToHex(proto.GetEdadealUid().GetValue()));
    }
}
