#pragma once

#include <crypta/lib/native/identifiers/lib/identifier.h>

#include <contrib/libs/re2/re2/re2.h>

static const re2::RE2 EDADEAL_GUID_REGEXP("([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})|([0-9a-f]{32})");
static const re2::RE2 EDADEAL_GUID_UNNORMALIZE_REGEXP("[0-9a-f]{32}");

namespace NIdentifiers {
    class TEdadealUid: public TTypedIdentifier<TEdadealUid, NCrypta::NIdentifiersProto::NIdType::EDADEAL_UID> {
    public:
        using TTypedIdentifier::TTypedIdentifier;

        static TString Next();

        NCrypta::NIdentifiersProto::TGenericID ToProto() const override;
        static TString FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto);

        static bool Validate(const TString&);
    protected:
        TString DoNormalize() const override;
    };
}
