#pragma once

#include "hostname.h"

#include <crypta/lib/native/identifiers/lib/identifier.h>
#include <crypta/lib/native/identifiers/lib/likelihood.h>

#include <contrib/libs/re2/re2/re2.h>
#include <util/string/subst.h>
#include <util/string/strip.h>


namespace NIdentifiers {
    static const size_t MAX_LOCAL_LENGTH = 64;
    static const size_t MAX_DOMAIN_LENGTH = 255;

    static const re2::RE2 COMMON_EMAIL_REGEXP(
        R"(^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:[a-z0-9!#$%&'*+/=?^_`{|}~\-\.]+)*)"
        R"(@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$)"
    );

    static const re2::RE2 YANDEX_TEAM_REGEXP(R"(.*@yandex\-team\.ru)");
    static const re2::RE2 YANDEX_TLD_REGEXP("@" + YANDEX_TLD);
    static const re2::RE2 GOOGLE_EMAIL_REGEXP("@googlemail.com");
    static const re2::RE2 UNNORMAL_EMAIL_REGEXP(R"((.*@.*yandex.*)|(.*@\d*ya\..{1,5}))");
    static const re2::RE2 YANDEX_DEFAULT_EMAIL_REGEXP(R"(.+@ya(ndex){0,1}\.ru$)");
    static const re2::RE2 YANDEX_EMAIL_REGEXP(".+@" + YANDEX_TLD);

    class TEmail: public TTypedIdentifier<TEmail, NCrypta::NIdentifiersProto::NIdType::EMAIL> {
    public:
        explicit TEmail(const TString& value);
        explicit TEmail(const NCrypta::NIdentifiersProto::TGenericID& proto);

        static TString Next();

        NCrypta::NIdentifiersProto::TGenericID ToProto() const override;
        static TString FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto);

        bool HasLikelihood() const override;

        static bool Validate(const TString&);
    protected:
        TString DoNormalize() const override;
        TString MakeClearRepresentation() const override;

        static bool IsUnnormalEmail(const TString&);
        static bool IsValidHeuristic(const TString&);
    };
}
