#include "fb_id.h"

#include <util/string/cast.h>

namespace NIdentifiers {
    bool TFbId::Validate(const TString& value) {
        return IsUint64(value);
    }

    TString TFbId::Next() {
        return NextNonZeroUInt();
    }

    NCrypta::NIdentifiersProto::TGenericID TFbId::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            proto.MutableFbId()->SetValue(FromString<ui64>(Normalize()));
        }
        return proto;
    }

    TString TFbId::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : ToString(proto.GetFbId().GetValue());
    }
}
