#include "gaid.h"

namespace NIdentifiers {
    bool TGaid::Validate(const TString& value) {
        return RE2::FullMatch(value, GAID_REGEXP);
    }

    TString TGaid::DoNormalize() const {
        TString normalized = Original;
        normalized.to_lower();
        if (normalized.size() == 32) {
            normalized = HexDigestDashes(normalized);
        }
        return normalized;
    }

    TString TGaid::Next() {
        TString output;
        while (output.size() < 32) {
            output.append(NextHexDigest());
        }
        return HexDigestDashes(output);
    }

    NCrypta::NIdentifiersProto::TGenericID TGaid::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            auto proto_big_int = HexToUInt128(Normalize());
            proto.MutableGaid()->MutableValue()->SetLo(proto_big_int.GetLo());
            proto.MutableGaid()->MutableValue()->SetHi(proto_big_int.GetHi());
        }
        return proto;
    }

    TString TGaid::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : HexDigestDashes(UIntToHex(proto.GetGaid().GetValue()));
    }

    bool TGaid::HasLikelihood() const {
        return true;
    }
}
