#pragma once

#include <crypta/lib/native/identifiers/lib/identifier.h>
#include <contrib/libs/re2/re2/re2.h>

namespace NIdentifiers {
    const static TString YANDEX_TLD{
        "("
        R"((yandex\.((ru|lv|ee|tm|tj|md|kg|az|lt|fr|uz|ua|kz|com|by|(com\.(tr|ge|am|ua|ru))|(co\.il)))))"
        R"(|(ya\.ru))"
        ")$"
    };
    const static TString YANDEX_DOMAIN{R"(^([a-zA-Z0-9.\-]+\.)?)" + YANDEX_TLD};
    const static re2::RE2 YANDEX_DOMAIN_RE{YANDEX_DOMAIN};

    const static TString YASTATIC{"yastatic.net"}; // no other domains in the wild


    class THostname: public TTypedIdentifier<THostname, NCrypta::NIdentifiersProto::NIdType::HOSTNAME> {
    public:
        using TTypedIdentifier::TTypedIdentifier;

        static TString Next();

        NCrypta::NIdentifiersProto::TGenericID ToProto() const override;
        static TString FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto);

        static bool Validate(const TString&);
        static bool Significate(const TString&);
        static bool IsYandex(const TString&);
        static bool IsYastatic(const TString&);

    protected:
        TString DoNormalize() const override;
    };
}
