#pragma once

#include "yandexuid.h"

#include <crypta/lib/native/identifiers/lib/identifier.h>
#include <contrib/libs/re2/re2/re2.h>

static const re2::RE2 ICOOKIE_REGEXP("^[1-9][0-9]{16,18}$");
// PP icookie has random old timestamp https://wiki.yandex-team.ru/serp/experiments/icookie2/opisanie/uuid/
static const ui64 UUID_ICOOKIE_MAX_TIMESTAMP{1'073'741'823ull};

namespace NIdentifiers {
    class TIcookie: public TCookieMixin, public TTypedIdentifier<TIcookie, NCrypta::NIdentifiersProto::NIdType::ICOOKIE> {
    public:
        using TTypedIdentifier::TTypedIdentifier;
        using TTypedIdentifier::Significate;
        using TCookieMixin::Next;
        using TCookieMixin::GetTimestamp;
        using TCookieMixin::GetMaxTimestamp;
        using TCookieMixin::GenerateRandomTimestamp;

        NCrypta::NIdentifiersProto::TGenericID ToProto() const override;
        static TString FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto);

        ui64 GetTimestamp() const;

        static bool Validate(const TString&);
        static bool Validate(const ui64);
        static bool Significate(const ui64);
    protected:
        static bool IsValidTimestamp(ui64);
        static bool IsValidRegexp(const TString&);
    };
}
