#include "idfa.h"

namespace NIdentifiers {
    bool TIdfa::Validate(const TString& value) {
        return RE2::FullMatch(value, IDFA_REGEXP);
    }

    TString TIdfa::DoNormalize() const {
        TString normalized = Original;
        normalized.to_upper();
        if (normalized.size() == 32) {
            normalized = HexDigestDashes(normalized);
        }
        return normalized;
    }

    TString TIdfa::Next() {
        TString output;
        while (output.size() < 32) {
            output.append(NextHexDigest());
        }
        return to_upper(HexDigestDashes(output));
    }

    NCrypta::NIdentifiersProto::TGenericID TIdfa::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            auto proto_big_int = HexToUInt128(Normalize());
            proto.MutableIdfa()->MutableValue()->SetLo(proto_big_int.GetLo());
            proto.MutableIdfa()->MutableValue()->SetHi(proto_big_int.GetHi());
        }
        return proto;
    }

    bool TIdfa::HasLikelihood() const {
        return true;
    }

    TString TIdfa::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : to_upper(HexDigestDashes(UIntToHex(proto.GetIdfa().GetValue())));
    }
}
