#pragma once

#include <crypta/lib/native/identifiers/lib/identifier.h>

#include <contrib/libs/re2/re2/re2.h>

static const re2::RE2 IDFA_REGEXP("(?i)(([0-9A-F]{8}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{12})|([0-9A-F]{32}))");

namespace NIdentifiers {
    class TIdfa: public TTypedIdentifier<TIdfa, NCrypta::NIdentifiersProto::NIdType::IDFA> {
    public:
        using TTypedIdentifier::TTypedIdentifier;
        static const size_t MIN_SIGNIFICANT_COUNT{1};
        static size_t CountSignificant(const TString& value) {
            return CountSignificantUniq(value);
        }

        static TString Next();

        NCrypta::NIdentifiersProto::TGenericID ToProto() const override;
        static TString FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto);

        bool HasLikelihood() const override;

        static bool Validate(const TString&);
    protected:
        TString DoNormalize() const override;
    };
}
