#pragma once

#include <crypta/lib/native/identifiers/lib/identifier.h>

namespace NIdentifiers {
    class TIdfaGaid: public TIdentifier {
    public:
        explicit TIdfaGaid(const TString& value);
        explicit TIdfaGaid(const NCrypta::NIdentifiersProto::TGenericID& proto);
        explicit TIdfaGaid(const TIdfaGaid& other);

        static TString Next();

        TString GetNext() const override {
            return Next();
        }

        NCrypta::NIdentifiersProto::TGenericID ToProto() const override;
        static TString FromProto(const NCrypta::NIdentifiersProto::TGenericID&);

        bool HasLikelihood() const override;

        static bool Validate(const TString&);
        static bool Significate(const TString&);
        virtual bool Significate() const override {
            return TIdfaGaid::Significate(Value());
        }

    protected:
        TString DoNormalize() const override;

    private:
        THolder<TIdentifier> Identifier;
        static bool IsLikeGaid(const TString&);
        static bool IsLikeIdfa(const TString&);
        virtual bool Validate() const override;
    };
}
