#include "ifv.h"

namespace NIdentifiers {
    bool TIfv::Validate(const TString& value) {
        return RE2::FullMatch(value, IFV_REGEXP);
    }

    TString TIfv::DoNormalize() const {
        TString normalized = Original;
        normalized.to_upper();
        if (normalized.size() == 32) {
            normalized = HexDigestDashes(normalized);
        }
        return normalized;
    }

    TString TIfv::Next() {
        TString output;
        while (output.size() < 32) {
            output.append(NextHexDigest());
        }
        return to_upper(HexDigestDashes(output));
    }

    NCrypta::NIdentifiersProto::TGenericID TIfv::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            auto proto_big_int = HexToUInt128(Normalize());
            proto.MutableIfv()->MutableValue()->SetLo(proto_big_int.GetLo());
            proto.MutableIfv()->MutableValue()->SetHi(proto_big_int.GetHi());
        }
        return proto;
    }

    bool TIfv::HasLikelihood() const {
        return true;
    }

    TString TIfv::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : to_upper(HexDigestDashes(UIntToHex(proto.GetIfv().GetValue())));
    }
}
