#include "imei.h"
#include <util/string/cast.h>

namespace NIdentifiers {
    static int CalcSum(const TString& s, const unsigned int len) {
        Y_ASSERT(s.size() >= len);

        int sum = 0;

        for (unsigned int i=0; i<len; i+=2) {
            sum += (s[i] - '0');
        }

        for (unsigned int i=1; i<len; i+=2) {
            int dbl = (s[i] - '0') * 2;
            sum += (dbl / 10 + dbl % 10);
        }

        return sum;
    }

    bool TImei::Validate(const TString& value) {
        bool regexOk = RE2::FullMatch(value, IMEI_REGEXP);
        if (regexOk) {
            if (value.size() == 16) {
                // IMEISV, no checksum
                return true;
            } else {
                int sum = CalcSum(value, 15);
                return (sum % 10) == 0;
            }
        }

        return false;
    }

    TString TImei::Next() {
        TString output;
        for (size_t index = 0; index < 14; ++index) {
            char nextSym = NextDigest();
            output.append(nextSym);
        }

        int sum = CalcSum(output, 14);
        char lastSym = '0';
        if ((sum % 10) != 0) {
            lastSym += (10 - sum % 10);
        }
        output.append(lastSym);

        return output;
    }

    NCrypta::NIdentifiersProto::TGenericID TImei::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            proto.MutableImei()->SetValue(Normalize());
        }
        return proto;
    }

    TString TImei::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : proto.GetImei().GetValue();
    }
}
