#include "kp_id.h"

#include <util/string/cast.h>

namespace NIdentifiers {
    bool TKpId::Validate(const TString& value) {
        return IsUint64(value);
    }

    TString TKpId::Next() {
        return NextNonZeroUInt();
    }

    NCrypta::NIdentifiersProto::TGenericID TKpId::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            proto.MutableKpId()->SetValue(FromString<ui64>(Normalize()));
        }
        return proto;
    }

    TString TKpId::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : ToString(proto.GetKpId().GetValue());
    }
}
