#pragma once

#include <util/string/strip.h>
#include <crypta/lib/native/identifiers/lib/identifier.h>
#include <crypta/lib/native/identifiers/lib/likelihood.h>

#include <contrib/libs/re2/re2/re2.h>

static const re2::RE2 POSSIBLE_CHARS_REGEXP("[a-zA-Z0-9@.-]+");
static const re2::RE2 TWO_OR_MORE_AT_REGEXP(".*@.*@.*");
static const re2::RE2 TWO_POINT_OR_HYPHEN_REGEXP(R"EOF(\w*[.-]{2}\w*)EOF");

static const size_t MAX_LOGIN_LENGTH = 40;

namespace NIdentifiers {
    class TLogin: public TTypedIdentifier<TLogin, NCrypta::NIdentifiersProto::NIdType::LOGIN> {
    public:
        template <class TValue>
        explicit TLogin(const TValue& value) : TTypedIdentifier(value) {
            Original = to_lower(Original);
            StripInPlace(Original);
        }

        static TString Next();

        NCrypta::NIdentifiersProto::TGenericID ToProto() const override;
        static TString FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto);

        bool HasLikelihood() const override;

        static bool Validate(const TString&);
    protected:
        TString DoNormalize() const override;
        TString MakeClearRepresentation() const override;
    };
}
