#include "mac.h"

#include <util/string/cast.h>
#include <util/string/subst.h>

namespace NIdentifiers {
    bool TMac::Validate(const TString& value) {
        return RE2::FullMatch(value, MAC_REGEXP);
    }

    TString TMac::DoNormalize() const {
        TString normalized = Original;
        // clean up trash
        SubstGlobal(normalized, ":", "", 0);
        SubstGlobal(normalized, "-", "", 0);
        // insert column
        return MacColumn(to_lower(normalized));
    }

    TString TMac::Next() {
        TString output;
        while(output.size() < MAC_LENGTH) {
            output.append(NextHexDigest());
        }
        return MacColumn(output);
    }

    NCrypta::NIdentifiersProto::TGenericID TMac::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            // drop delimiters from hex string
            TString value = Normalize();
            SubstGlobal(value, ":", "", 0);
            proto.MutableMac()->SetValue(IntFromString<ui64, 16>(value));
        }
        return proto;
    }

    TString TMac::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : MacColumn(UIntToHex(proto.GetMac().GetValue()).substr(4));
    }

    TString MacColumn(const TString& value) {
        TString local{value};
        for (size_t position = 0, index = 0; position < MAC_LENGTH; ++position, ++index) {
            if (position && !(position & 1)) {
                local.insert(index, ":");
                ++index;
            }
        }
        return local;
    }
}
