#pragma once

#include <crypta/lib/native/identifiers/lib/identifier.h>

#include <contrib/libs/re2/re2/re2.h>

static const re2::RE2 MAC_REGEXP("[0-9a-fA-F]{2}(((:[0-9a-fA-F]{2}){5})|((-[0-9a-fA-F]{2}){5})|(([0-9a-fA-F]{2}){5}))");
static const size_t MAC_LENGTH = 12;  // without any splitter

namespace NIdentifiers {
    TString MacColumn(const TString&);

    class TMac: public TTypedIdentifier<TMac, EIdType::MAC> {
    public:
        using TTypedIdentifier::TTypedIdentifier;

        static TString Next();

        NCrypta::NIdentifiersProto::TGenericID ToProto() const override;
        static TString FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto);

        static bool Validate(const TString&);
    protected:
        TString DoNormalize() const override;
    };
}
