#include "mac.h"
#include "mac_ext.h"

#include <library/cpp/digest/md5/md5.h>
#include <util/string/cast.h>
#include <util/string/hex.h>
#include <util/string/subst.h>

namespace NIdentifiers {
    bool TMacExt::Validate(const TString& value) {
        return RE2::FullMatch(value, MAC_EXT_REGEXP);
    }

    TString TMacExt::DoNormalize() const {
        TString normalized = Original;
        // clean up trash
        SubstGlobal(normalized, ":", "", 0);
        SubstGlobal(normalized, "-", "", 0);
        // insert column
        return to_upper(MacColumn(normalized));
    }

    TString TMacExt::Next() {
        return to_upper(TMac::Next());
    }

    TString TMacExt::ComputeMd5Hash() const {
        TString str(Normalize());
        SubstGlobal(str, ":", "", 0);
        return to_upper(MD5::Calc(HexDecode(str)));
    }

    NCrypta::NIdentifiersProto::TGenericID TMacExt::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            // drop delimiters from hex string
            TString value = Normalize();
            SubstGlobal(value, ":", "", 0);
            proto.MutableMac()->SetValue(IntFromString<ui64, 16>(value));
        }
        return proto;
    }

    TString TMacExt::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : to_upper(TMac::FromProto(proto));
    }
}
