#pragma once

#include <crypta/lib/native/identifiers/lib/identifier.h>

#include <contrib/libs/re2/re2/re2.h>

static const re2::RE2 MAC_EXT_REGEXP("[0-9a-fA-F]{2}(((:[0-9a-fA-F]{2}){5})|((-[0-9a-fA-F]{2}){5})|(([0-9a-fA-F]{2}){5}))");
static const size_t MAC_EXT_LENGTH = 12;  // without any splitter

namespace NIdentifiers {
    class TMacExt: public TTypedIdentifier<TMacExt, EIdType::MAC_EXT> {
    public:
        using TTypedIdentifier::TTypedIdentifier;
        // explicit TMacExt(const TString& value);
        // explicit TMacExt(const NCrypta::NIdentifiersProto::TGenericID& proto);

        static TString Next();

        TString ComputeMd5Hash() const override;
        NCrypta::NIdentifiersProto::TGenericID ToProto() const override;
        static TString FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto);

        static bool Validate(const TString&);
    protected:
        TString DoNormalize() const override;
    };
}
