#pragma once

#include <crypta/lib/native/identifiers/lib/identifier.h>

#include <contrib/libs/re2/re2/re2.h>

static const re2::RE2 MM_DEVICE_ID_REGEXP("([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})|([0-9a-fA-F]{32})");
static const re2::RE2 SHORT_MM_DEVICE_ID_REGEXP("([0-9a-fA-F]{20})|([0-9a-fA-F]{24})");
static const re2::RE2 UPPER_MM_REGEXP("([0-9A-F]{8}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{12})|([0-9A-F]{32})");
static const re2::RE2 LOWER_MM_REGEXP("([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})|([0-9a-f]{32})");
static const re2::RE2 ONLY_DIGITS_REGEXP("([0-9]{8}-[0-9]{4}-[0-9]{4}-[0-9]{4}-[0-9]{12})|([0-9]{32})");

namespace NIdentifiers {
    class TMmDeviceId: public TTypedIdentifier<TMmDeviceId, NCrypta::NIdentifiersProto::NIdType::MM_DEVICE_ID> {
    public:
        using TTypedIdentifier::TTypedIdentifier;
        static const size_t MIN_SIGNIFICANT_COUNT{1u};
        static size_t CountSignificant(const TString& value) {
            return CountSignificantUniq(value);
        }

        static TString Next();

        NCrypta::NIdentifiersProto::TGenericID ToProto() const override;
        static TString FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto);

        bool HasLikelihood() const override;

        static bool Validate(const TString&);

    protected:
        TString DoNormalize() const override;
        TString DoStrictNormalize() const override;
    };
}
