#include "mm_device_id_hash.h"

#include <util/string/cast.h>

namespace NIdentifiers {
    bool TMmDeviceIdHash::Validate(const TString& value) {
        return IsUint64(value);
    }

    TString TMmDeviceIdHash::Next() {
        return NextNonZeroUInt();
    }

    NCrypta::NIdentifiersProto::TGenericID TMmDeviceIdHash::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            proto.MutableMmDeviceIdHash()->SetValue(FromString<ui64>(Normalize()));
        }
        return proto;
    }

    TString TMmDeviceIdHash::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : ToString(proto.GetMmDeviceIdHash().GetValue());
    }
}
