#include "oaid.h"

namespace NIdentifiers {
    bool TOaid::Validate(const TString& value) {
        return RE2::FullMatch(value, OAID_REGEXP);
    }

    TString TOaid::DoNormalize() const {
        TString normalized = Original;
        normalized.to_lower();
        if (normalized.size() == 32) {
            normalized = HexDigestDashes(normalized);
        }
        return normalized;
    }

    TString TOaid::Next() {
        TString output;
        while (output.size() < 32) {
            output.append(NextHexDigest());
        }
        return HexDigestDashes(output);
    }

    NCrypta::NIdentifiersProto::TGenericID TOaid::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            auto proto_big_int = HexToUInt128(Normalize());
            proto.MutableOaid()->MutableValue()->SetLo(proto_big_int.GetLo());
            proto.MutableOaid()->MutableValue()->SetHi(proto_big_int.GetHi());
        }
        return proto;
    }

    TString TOaid::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : HexDigestDashes(UIntToHex(proto.GetOaid().GetValue()));
    }

    bool TOaid::HasLikelihood() const {
        return true;
    }
}
