#include "ok_id.h"

#include <util/string/cast.h>

namespace NIdentifiers {
    bool TOkId::Validate(const TString& value) {
        return IsUint64(value) && value != "0";
    }

    TString TOkId::Next() {
        return NextNonZeroUInt();
    }

    NCrypta::NIdentifiersProto::TGenericID TOkId::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            proto.MutableOkId()->SetValue(FromString<ui64>(Normalize()));
        }
        return proto;
    }

    TString TOkId::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : ToString(proto.GetOkId().GetValue());
    }
}
