#include "partner_record_id.h"

#include <util/random/random.h>

namespace NIdentifiers {
    bool TPartnerRecordId::Validate(const TString& value) {
        return RE2::FullMatch(value, PARTNER_RECORD_ID_REGEXP);
    }

    TString TPartnerRecordId::Next() {
        size_t output_len = 10u + RandomNumber<size_t>(5);
        TString output(NextAlphaNumeric());
        while(output.size() < output_len) {
            output.append(NextAlphaNumeric("_-:;#"));
        }
        return output;
    }

    NCrypta::NIdentifiersProto::TGenericID TPartnerRecordId::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            proto.MutablePartnerRecordId()->SetValue(Normalize());
        }
        return proto;
    }

    TString TPartnerRecordId::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : proto.GetPartnerRecordId().GetValue();
    }
}
