#pragma once

#include <crypta/lib/native/identifiers/lib/identifier.h>

#include <contrib/libs/libphonenumber/cpp/src/phonenumbers/phonenumberutil.h>
#include <contrib/libs/re2/re2/re2.h>
#include <util/generic/ptr.h>

static const re2::RE2 ALLOWED_CHARS_REGEXP(R"EOF([0-9 \(\)\+\-]*)EOF");

namespace NIdentifiers {
    class TPhone: public TTypedIdentifier<TPhone, NCrypta::NIdentifiersProto::NIdType::PHONE> {
    public:
        explicit TPhone(const TString& value);
        explicit TPhone(const NCrypta::NIdentifiersProto::TGenericID& proto);
        explicit TPhone(const TPhone& other);

        static TString Next();

        NCrypta::NIdentifiersProto::TGenericID ToProto() const override;
        static TString FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto);

        static bool Validate(const TString&);
    protected:
        TString DoNormalize() const override;
        TString ComputeMd5Hash() const override;
        TString ComputeSha256Hash() const override;

    private:
        THolder<i18n::phonenumbers::PhoneNumber> Phone;
    };
}
