#include "puid.h"

#include <util/string/cast.h>

namespace NIdentifiers {
    bool TPuid::Validate(const TString& value) {
        return (value != "0") && (value != "007007007") && IsUint64(value);
    }

    TString TPuid::Next() {
        return NextNonZeroUInt();
    }

    NCrypta::NIdentifiersProto::TGenericID TPuid::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            proto.MutablePuid()->SetValue(FromString<ui64>(Normalize()));
        }
        return proto;
    }

    TString TPuid::DoNormalize() const {
        return ToString<ui64>(FromString<ui64>(Original));
    }

    TString TPuid::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : ToString(proto.GetPuid().GetValue());
    }
}
