#pragma once

#include <crypta/lib/native/identifiers/lib/identifier.h>
#include <util/string/builder.h>
#include <contrib/libs/re2/re2/re2.h>

static const re2::RE2 SSP_USER_ID_REGEXP("(\\d+)@([-A-Za-z0-9_]+)");

namespace NIdentifiers {
    class TSspUserId: public TTypedIdentifier<TSspUserId, NCrypta::NIdentifiersProto::NIdType::SSP_USER_ID> {
    public:
        using TTypedIdentifier::TTypedIdentifier;

        explicit TSspUserId(const ui64& sspid, const TString& ssp_user_id):
            TSspUserId(TStringBuilder() << sspid << "@" << ssp_user_id) {};

        static TString Next();

        NCrypta::NIdentifiersProto::TGenericID ToProto() const override;
        static TString FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto);

        static bool Validate(const TString&);
        static bool Significate(const TString&);

    protected:
        TString DoNormalize() const override;
    };
}

