#include "uuid.h"

namespace NIdentifiers {
    bool TUuid::Validate(const TString& value) {
        return RE2::FullMatch(value, UUID_REGEXP);
    }

    TString TUuid::Next() {
        TString output;
        for (size_t index = 0; index < 32; ++index) {
            output.append(NextHexDigest());
        }
        return output;
    }

    NCrypta::NIdentifiersProto::TGenericID TUuid::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            auto proto_big_int = HexToUInt128(Normalize());
            proto.MutableUuid()->MutableValue()->SetLo(proto_big_int.GetLo());
            proto.MutableUuid()->MutableValue()->SetHi(proto_big_int.GetHi());
        }
        return proto;
    }

    TString TUuid::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : UIntToHex(proto.GetUuid().GetValue());
    }
}
