#include "vk_id.h"

#include <util/random/random.h>

namespace NIdentifiers {
    bool TVkId::Validate(const TString& value) {
        return RE2::FullMatch(value, VKID_REGEXP) && value != "0";
    }

    TString TVkId::Next() {
        TString output;
        size_t id_len = 7 + RandomNumber<size_t>(5);
        while (output.size() < id_len) {
            output.append(NextAlpha());
        }
        return output;
    }

    NCrypta::NIdentifiersProto::TGenericID TVkId::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            proto.MutableVkId()->SetValue(Normalize());
        }
        return proto;
    }

    TString TVkId::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : proto.GetVkId().GetValue();
    }
}
