#include "vk_name.h"

#include <crypta/lib/native/identifiers/lib/utils.h>
#include <util/random/random.h>

namespace NIdentifiers {
    bool TVkName::Validate(const TString& value) {
        return value.size() > 0;
    }

    TString TVkName::Next() {
        TString output;
        size_t id_len = 3 + RandomNumber<size_t>(5);
        while (output.size() < id_len) {
            output.append(NextAlpha());
        }
        return output;
    }

    NCrypta::NIdentifiersProto::TGenericID TVkName::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            proto.MutableVkName()->SetValue(Normalize());
        }
        return proto;
    }

    TString TVkName::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : proto.GetVkName().GetValue();
    }
}
