#include "xuniqguid.h"

#include <util/string/cast.h>

namespace NIdentifiers {
    bool TXUniqGuid::Validate(const TString& value) {
        return IsUint64(value);
    }

    TString TXUniqGuid::Next() {
        return NextNonZeroUInt();
    }

    NCrypta::NIdentifiersProto::TGenericID TXUniqGuid::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            proto.MutableXUniqGuid()->SetValue(FromString<ui64>(Normalize()));
        }
        return proto;
    }

    TString TXUniqGuid::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : ToString(proto.GetXUniqGuid().GetValue());
    }
}
