#include "yamoney_id.h"

#include <util/string/cast.h>

namespace NIdentifiers {
    bool TYamoneyId::Validate(const TString& value) {
        return IsUint64(value);
    }

    TString TYamoneyId::Next() {
        return NextNonZeroUInt();
    }

    NCrypta::NIdentifiersProto::TGenericID TYamoneyId::ToProto() const {
        auto proto = TIdentifier::ToProto();
        if (!proto.HasRawValue()) {
            proto.MutableYamoneyId()->SetValue(FromString<ui64>(Normalize()));
        }
        return proto;
    }

    TString TYamoneyId::FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto) {
        return proto.HasRawValue() ? proto.GetRawValue() : ToString(proto.GetYamoneyId().GetValue());
    }
}
