#pragma once

#include <crypta/lib/native/identifiers/lib/identifier.h>
#include <contrib/libs/re2/re2/re2.h>

static const re2::RE2 COOKIE_REGEXP("[0]*[1-9][0-9]{16,19}");
static const ui64 MIN_TIMESTAMP{900'000'000ull}; // 09.07.1998, 20:00:00
static const ui64 FIXED_MAX_TIMESTAMP{1'593'000'000ull};

namespace NIdentifiers {
    /**
     * https://wiki.yandex-team.ru/Cookies/yandexuid/
     * Формат
     *   Флаги в Set-Cookie: HttpOnly + Secure не использовать
     *   левая часть -- набор рандомных чисел (от 7 до 9 цифр) 2014-02-25
     *       из-за проблемы 2^64 в yabs (от 7 до 10 цифр)
     *   левая часть -- не должно быть лидирующего нуля upd: 2015.01.28
     *   правая часть -- unixtimestamp (только секунды; 10 цифр)
    **/

    class TCookieMixin {
    public:
        static ui64 GetTimestamp(const TString&);
        static ui64 GetTimestamp(ui64);
        static ui64 GetMaxTimestamp();
        static TString GenerateRandomTimestamp();
        static TString GenerateRandomTimestamp(ui64 maxTimestamp);

        static TString Next();

    protected:
        static bool IsValidTimestamp(ui64);
        static bool IsValidRegexp(const TString&);
    };

    class TYandexuid: public TCookieMixin, public TTypedIdentifier<TYandexuid, NCrypta::NIdentifiersProto::NIdType::YANDEXUID> {
    public:
        using TTypedIdentifier::TTypedIdentifier;
        using TCookieMixin::Next;
        using TCookieMixin::GetTimestamp;
        using TCookieMixin::GetMaxTimestamp;
        using TCookieMixin::GenerateRandomTimestamp;
        using TTypedIdentifier::Significate;

        NCrypta::NIdentifiersProto::TGenericID ToProto() const override;
        static TString FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto);

        ui64 GetTimestamp() const;

        static bool Validate(const TString&);
        static bool Validate(const ui64);
        static bool Significate(const ui64);

    protected:
        TString DoNormalize() const override;
    };
}
