#pragma once

#include <crypta/lib/native/identifiers/lib/identifier.h>

namespace NIdentifiers {
    class TYSClid: public TTypedIdentifier<TYSClid, NCrypta::NIdentifiersProto::NIdType::YSCLID> {
    public:
        using TTypedIdentifier::TTypedIdentifier;

        static TString Next();

        NCrypta::NIdentifiersProto::TGenericID ToProto() const override;
        static TString FromProto(const NCrypta::NIdentifiersProto::TGenericID& proto);

        static bool Validate(const TString&);
        static bool Significate(const TString&);

        static ui64 GetTimestamp(const TString& value);
        ui64 GetTimestamp() const;
    };
}
