#include "likelihood.h"

namespace NLikelihoodFeatures {
    double TLikelihoodFeatures::FrequencySpread(const TString &identifier) {
        TVector<int> freqs = TLikelihoodFeatures::Frequencies(identifier);
        return TLikelihoodFeatures::Variance(freqs, identifier.size());
    }

    double TLikelihoodFeatures::Alternating(const TString& identifier) {
        TVector<int> diffs = TLikelihoodFeatures::Signs(identifier);
        return TLikelihoodFeatures::Variance(diffs, identifier.size());
    }

    double TLikelihoodFeatures::Periodicity(const TString& identifier) {
        TVector <int> periodFreqs;
        TVector <TString> periods = TLikelihoodFeatures::Periods(identifier);
        for (auto period : periods) {
            periodFreqs.push_back(TLikelihoodFeatures::FrequencySpread(period));
        }
        int resultSum = 0;
        for (int freq : periodFreqs) {
            resultSum += freq;
        }
        return resultSum;
    }

    double TLikelihoodFeatures::Repetitions(const TString& identifier) {
        TMap<TString, int> substringReps = TLikelihoodFeatures::SubstringsRepetitions(identifier);
        int repsNumber = 0;
        for (auto elem: substringReps) {
            repsNumber += substringReps[elem.first];
        }
        return repsNumber;
    }
}
