#pragma once
#include <crypta/lib/proto/identifiers/identifiers.pb.h>
#include <crypta/lib/proto/identifiers/id_type.pb.h>

#include <contrib/libs/re2/re2/re2.h>

#include <util/generic/strbuf.h>

static const ui64 YEAR_IN_SECONDS = 365 * 24 * 60 * 60;
static const TString HEX = "abcdef";
static const TString DIGEST = "0123456789";
static const TString HEX_DIGEST = HEX + DIGEST;
static const TString ALPHABET = "abcdefghijklmnopqrstuvwxyz";
static const TString ALPHA_NUMERIC = ALPHABET + DIGEST;
static const ui64 MAX_IDENTIFIER_LENGTH = 1000;
static const re2::RE2 HEX_DIGEST_REGEXP("^[0-9a-fA-F]+$");

NCrypta::NIdentifiersProto::UInt128 HexToUInt128(const TString&, const bool autofill=false);
NCrypta::NIdentifiersProto::UInt256 HexToUInt256(const TString&, const bool autofill=false);

TString UIntToHex(ui64);
TString UIntToHex(const NCrypta::NIdentifiersProto::UInt128&);
TString UIntToHex(const NCrypta::NIdentifiersProto::UInt256&);
TString HexDigestDashes(const TString&);

bool IsUint32(const TString&);
bool IsUint64(const TString&);

TString NextUInt();
TString NextNonZeroUInt();
char NextDigest();
char NextHexDigest();
char NextAlpha();
char NextAlphaNumeric();
char NextAlphaNumeric(const TString&);

bool IsUint(const TString&, size_t, const char*);
bool IsAllDigits(const TString&);
bool IsHexadecimal(const TString&);

TString ComputeMd5Hash(const TString&);
TString ComputeSha256Hash(const TString&);
ui64 ComputeYabsHash(const TString&);

std::tuple<TString, TString> SplitEmail(const TString &email);

size_t CountSignificant(const TStringBuf);
size_t CountSignificantUniq(const TStringBuf);

TString UintToStringWithBase(ui64 value, int base=10);
ui64 UintFromStringWithBase(const TString& value, int base=10);
