LIBRARY(identifiers)

PEERDIR(
    contrib/libs/libphonenumber
    contrib/libs/re2
    crypta/lib/proto/identifiers
    library/cpp/digest/md5
    library/cpp/openssl/crypto
    library/cpp/unicode/punycode
    library/cpp/string_utils/csv
)

OWNER(
    g:crypta
    g:crypta-lib
    g:crypta-idfy
)

ADDINCL(
    GLOBAL contrib/libs/libphonenumber/cpp/src
)

RESOURCE(
    blacklists/list.csv /blacklist.csv
)

SRCS(
    blacklist.cpp
    generic.cpp
    identifier.cpp
    likelihood.cpp
    utils.cpp
    blacklists/list.cpp
    id_types/alisa_device_id.cpp
    id_types/android_id.cpp
    id_types/auto_id.cpp
    id_types/avito_hash.cpp
    id_types/avito_id.cpp
    id_types/cryptaid.cpp
    id_types/direct_client_id.cpp
    id_types/distrr1.cpp
    id_types/distrui.cpp
    id_types/dit_id.cpp
    id_types/duid.cpp
    id_types/edadeal_uid.cpp
    id_types/email.cpp
    id_types/fb_id.cpp
    id_types/gaid.cpp
    id_types/hostname.cpp
    id_types/icookie.cpp
    id_types/idfa.cpp
    id_types/idfa_gaid.cpp
    id_types/ifv.cpp
    id_types/imei.cpp
    id_types/kp_id.cpp
    id_types/login.cpp
    id_types/mac.cpp
    id_types/mac_ext.cpp
    id_types/md5.cpp
    id_types/mm_device_id.cpp
    id_types/mm_device_id_hash.cpp
    id_types/oaid.cpp
    id_types/ok_id.cpp
    id_types/partner_record_id.cpp
    id_types/phone.cpp
    id_types/puid.cpp
    id_types/sha256.cpp
    id_types/ssp.cpp
    id_types/uuid.cpp
    id_types/vk_id.cpp
    id_types/vk_name.cpp
    id_types/xuniqguid.cpp
    id_types/yamoney_id.cpp
    id_types/yandexuid.cpp
    id_types/ysclid.cpp
)

END()
