#include <iosfwd>

#include <crypta/lib/native/identifiers/lib/generic.h>
#include <crypta/lib/native/identifiers/lib/id_types/all.h>
#include <library/cpp/testing/unittest/registar.h>

template <class TypeIdentifier>
void IdentifierTest(TString bad_prefix) {
    TString prev;
    for (size_t index = 0; index < 10; ++index) {
        TString next = TypeIdentifier::Next();
        UNIT_ASSERT(prev != next);
        UNIT_ASSERT(next.size() > 1);
        UNIT_ASSERT(TypeIdentifier(next).IsValid());
        UNIT_ASSERT(!TypeIdentifier(bad_prefix + next).IsValid());
        prev = next;
    }
}

template <class TypeIdentifier>
void GenericIdentifierTest(TString bad_prefix) {
    TString prev;
    auto proto_type = TypeIdentifier("").GetType();
    for (size_t index = 0; index < 10; ++index) {
        TString next = NIdentifiers::TGenericID::Next(proto_type);
        UNIT_ASSERT(prev != next);
        UNIT_ASSERT(next.size() > 1);
        UNIT_ASSERT(TypeIdentifier(next).IsValid());
        UNIT_ASSERT(NIdentifiers::TGenericID(proto_type, next).IsValid());
        UNIT_ASSERT(!TypeIdentifier(bad_prefix + next).IsValid());
        UNIT_ASSERT(!NIdentifiers::TGenericID(proto_type, bad_prefix + next).IsValid());
        prev = next;
    }
}

Y_UNIT_TEST_SUITE(TestNextIdentifier) {

    Y_UNIT_TEST(TEST_ssp_user_id_Next) {
        TString prev;
        for (size_t index = 0; index < 10; ++index) {
            TString next = NIdentifiers::TSspUserId::Next();
            UNIT_ASSERT(next.size() > 0);
            UNIT_ASSERT(next != prev);
            UNIT_ASSERT(NIdentifiers::TSspUserId(next).IsValid());
            prev = next;
        }
        UNIT_ASSERT(!NIdentifiers::TSspUserId("").IsValid());
    }

    Y_UNIT_TEST(TEST_email_next) {
        TString prev;
        for (size_t index = 0; index < 10; ++index) {
            TString next = NIdentifiers::TEmail::Next();
            UNIT_ASSERT(next.size() > 0);
            UNIT_ASSERT(next.size() < 25);
            UNIT_ASSERT(next.find('@') >= 5);
            UNIT_ASSERT(next.find('@') <= 10);
            UNIT_ASSERT(next != prev);
            UNIT_ASSERT(NIdentifiers::TEmail(next).IsValid());
            UNIT_ASSERT(!NIdentifiers::TEmail("bad@" + next).IsValid());
            prev = next;
        }
    }

    Y_UNIT_TEST(TEST_yuid_next) {
        IdentifierTest<NIdentifiers::TYandexuid>("-1");
    }

    Y_UNIT_TEST(TEST_icookie_next) {
        IdentifierTest<NIdentifiers::TIcookie>("-1");
    }

    Y_UNIT_TEST(TEST_fb_id_Next) {
        IdentifierTest<NIdentifiers::TFbId>("z");
    }

    Y_UNIT_TEST(TEST_vk_id_Next) {
        IdentifierTest<NIdentifiers::TVkId>("~vk");
    }

    Y_UNIT_TEST(TEST_avito_hash_Next) {
        IdentifierTest<NIdentifiers::TAvitoHash>("0");
    }

    Y_UNIT_TEST(TEST_avito_id_Next) {
        IdentifierTest<NIdentifiers::TAvitoId>("-1");
    }

    Y_UNIT_TEST(TEST_crypta_id_Next) {
        IdentifierTest<NIdentifiers::TCryptaId>("-1");
    }

    Y_UNIT_TEST(TEST_distr_r1_Next) {
        IdentifierTest<NIdentifiers::TDistrR1>("0");
    }

    Y_UNIT_TEST(TEST_distr_ui_Next) {
        IdentifierTest<NIdentifiers::TDistrUI>("0");
    }

    Y_UNIT_TEST(TEST_dit_id_Next) {
        IdentifierTest<NIdentifiers::TDitId>("0");
    }

    Y_UNIT_TEST(TEST_duid_Next) {
        IdentifierTest<NIdentifiers::TDuid>("-");
    }

    Y_UNIT_TEST(TEST_gaid_Next) {
        IdentifierTest<NIdentifiers::TGaid>("0");
    }

    Y_UNIT_TEST(TEST_idfa_Next) {
        IdentifierTest<NIdentifiers::TIdfa>("0");
    }

    Y_UNIT_TEST(TEST_ifv_Next) {
        IdentifierTest<NIdentifiers::TIfv>("0");
    }

    Y_UNIT_TEST(TEST_idfa_gaid_Next) {
        IdentifierTest<NIdentifiers::TIdfaGaid>("0");
    }

    Y_UNIT_TEST(TEST_kp_id_Next) {
        IdentifierTest<NIdentifiers::TKpId>("-0");
    }

    Y_UNIT_TEST(TEST_login_Next) {
        TString prev;
        for (size_t index = 0; index < 10; ++index) {
            TString next = NIdentifiers::TLogin::Next();
            UNIT_ASSERT(next.size() > 0);
            UNIT_ASSERT(next.size() < 25);
            UNIT_ASSERT(next.find('@') == TString::npos);
            UNIT_ASSERT(next != prev);
            UNIT_ASSERT(NIdentifiers::TLogin(next).IsValid());
            UNIT_ASSERT(!NIdentifiers::TLogin("phne--e" + next).IsValid());
            prev = next;
        }
    }

    Y_UNIT_TEST(TEST_mac_Next) {
        IdentifierTest<NIdentifiers::TMac>("0");
    }

    Y_UNIT_TEST(TEST_md5_Next) {
        IdentifierTest<NIdentifiers::TMd5>("0");
    }

    Y_UNIT_TEST(TEST_email_md5_Next) {
        IdentifierTest<NIdentifiers::TEmailMd5>("0");
    }

    Y_UNIT_TEST(TEST_phone_md5_Next) {
        IdentifierTest<NIdentifiers::TPhoneMd5>("0");
    }

    Y_UNIT_TEST(TEST_macExt_Next) {
        IdentifierTest<NIdentifiers::TMacExt>("0");
    }

    Y_UNIT_TEST(TEST_macExt_md5_Next) {
        IdentifierTest<NIdentifiers::TMacExtMd5>("0");
    }

    Y_UNIT_TEST(TEST_mm_device_id_Next) {
        IdentifierTest<NIdentifiers::TMmDeviceId>("0");
    }

    Y_UNIT_TEST(TEST_ok_id_Next) {
        IdentifierTest<NIdentifiers::TOkId>("-1");
    }

    Y_UNIT_TEST(TEST_partner_record_id_Next) {
        IdentifierTest<NIdentifiers::TPartnerRecordId>("!");
    }

    Y_UNIT_TEST(TEST_phone_Next) {
        IdentifierTest<NIdentifiers::TPhone>("0");
    }

    Y_UNIT_TEST(TEST_puid_Next) {
        IdentifierTest<NIdentifiers::TPuid>("-");
    }

    Y_UNIT_TEST(TEST_sha256_Next) {
        IdentifierTest<NIdentifiers::TSha256>("0");
    }

    Y_UNIT_TEST(TEST_email_sha256_Next) {
        IdentifierTest<NIdentifiers::TEmailSha256>("0");
    }

    Y_UNIT_TEST(TEST_phone_sha256_Next) {
        IdentifierTest<NIdentifiers::TPhoneSha256>("0");
    }

    Y_UNIT_TEST(TEST_uuid_Next) {
        IdentifierTest<NIdentifiers::TUuid>("0");
    }

    Y_UNIT_TEST(TEST_xuniq_guid_Next) {
        IdentifierTest<NIdentifiers::TXUniqGuid>("-1");
    }

    Y_UNIT_TEST(TEST_yamoney_id_Next) {
        IdentifierTest<NIdentifiers::TYamoneyId>("-1");
    }

    Y_UNIT_TEST(TEST_mm_dev_id_hash_Next) {
        IdentifierTest<NIdentifiers::TMmDeviceIdHash>("-1");
    }

    Y_UNIT_TEST(TEST_android_id_Next) {
        IdentifierTest<NIdentifiers::TAndroidId>("0");
    }

    Y_UNIT_TEST(TEST_imei_Next) {
        IdentifierTest<NIdentifiers::TImei>("t");
    }

    Y_UNIT_TEST(TEST_generic_id_Next) {
        GenericIdentifierTest<NIdentifiers::TGaid>("-1");
        GenericIdentifierTest<NIdentifiers::TIdfa>("-1");
        GenericIdentifierTest<NIdentifiers::TKpId>("-1");
        GenericIdentifierTest<NIdentifiers::TMac>("-1");
        GenericIdentifierTest<NIdentifiers::TYamoneyId>("-1");
        GenericIdentifierTest<NIdentifiers::TYandexuid>("-1");
    }

    Y_UNIT_TEST(TEST_ysclid_Next) {
        IdentifierTest<NIdentifiers::TYSClid>("@");
    }
}
