#include <iosfwd>

#include <crypta/lib/native/identifiers/lib/generic.h>
#include <crypta/lib/native/identifiers/lib/id_types/all.h>
#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TestProtoConvertHelpers) {

    Y_UNIT_TEST(TEST_invalid_uint128_length) {
        // Should check is incorrect len hexdigest throw exception
        UNIT_ASSERT_EXCEPTION_CONTAINS(HexToUInt128("ffffFFFFffffFFFFffffFFFFffffFFF"),
                                       yexception, "incorrect hexdigest size 31");
        UNIT_ASSERT_EXCEPTION_CONTAINS(HexToUInt128("ffffFFFFffffFFFFffffFFFFffffFFFfF"),
                                       yexception, "incorrect hexdigest size 33");
    }

    Y_UNIT_TEST(TEST_invalid_uint256_length) {
        // Should check is incorrect len hexdigest throw exception
        UNIT_ASSERT_EXCEPTION_CONTAINS(HexToUInt128("ffffFFFFffffFFFFffffFFFFffffFFFF"
                                                                               "ffffFFFFffffFFFFffffFFFFffffFFF"),
                                       yexception, "incorrect hexdigest size 63");
        UNIT_ASSERT_EXCEPTION_CONTAINS(HexToUInt128("ffffFFFFffffFFFFffffFFFFffffFFFF"
                                                                               "ffffFFFFffffFFFFffffFFFFffffFFFFf"),
                                       yexception, "incorrect hexdigest size 65");
    }

    Y_UNIT_TEST(TEST_to_uint128) {
        // should check is correct convert hexdigest string to uin128
        {
            // test all F max value
            auto proto = HexToUInt128("ffff-FFFF-ffff-FFFF-ffff-FFFF-ffff-FFFF");
            UNIT_ASSERT_EQUAL(proto.GetLo(), 0xffffffffffffffff);
            UNIT_ASSERT_EQUAL(proto.GetHi(), 0xffffffffffffffff);
        }

        {
            // test all 0 min value
            auto proto = HexToUInt128("00000000000000000000000000000000");
            UNIT_ASSERT_EQUAL(proto.GetLo(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetHi(), 0x0);
        }

        {
            // test half/half some value
            auto proto = HexToUInt128("0000000000000000ffffffffffffffff");
            UNIT_ASSERT_EQUAL(proto.GetLo(), 0xffffffffffffffff);
            UNIT_ASSERT_EQUAL(proto.GetHi(), 0x0);
        }

        {
            // test half/half some value
            auto proto = HexToUInt128("ffffffffffffffff0000000000000000");
            UNIT_ASSERT_EQUAL(proto.GetLo(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetHi(), 0xffffffffffffffff);
        }

        {
            // test random value
            auto proto = HexToUInt128("D41D8CD98F00B204E9800998ECF8427E");
            UNIT_ASSERT_EQUAL(proto.GetLo(), 0xe9800998ecf8427e);
            UNIT_ASSERT_EQUAL(proto.GetHi(), 0xd41d8cd98f00b204);
        }

        {
            // test random value
            auto proto = HexToUInt128("E9800998ECF8427ED41D8CD98F00B204");
            UNIT_ASSERT_EQUAL(proto.GetLo(), 0xd41d8cd98f00b204);
            UNIT_ASSERT_EQUAL(proto.GetHi(), 0xe9800998ecf8427e);
        }

        {
            // some more random test
            auto proto = HexToUInt128("B16B00B5-dabbad00-deadbeaf-BAADA555");
            UNIT_ASSERT_EQUAL(proto.GetLo(), 0xdeadbeafbaada555);
            UNIT_ASSERT_EQUAL(proto.GetHi(), 0xb16b00b5dabbad00);
        }

        {
            // and last one test
            auto proto = HexToUInt128("00000000-12345678-90ABCDEF-00000000");
            UNIT_ASSERT_EQUAL(proto.GetLo(), 0x90abcdef00000000);
            UNIT_ASSERT_EQUAL(proto.GetHi(), 0x12345678);
        }
    }

    Y_UNIT_TEST(TEST_to_uint256) {
        // should check is correct convert hexdigest string to uin256
        {
            // test all F max value
            auto proto = HexToUInt256(
                "ffff-FFFF-ffff-FFFF-ffff-FFFF-ffff-FFFF"
                "ffff-FFFF-ffff-FFFF-ffff-FFFF-ffff-FFFF"
            );
            UNIT_ASSERT_EQUAL(proto.GetV0(), 0xffffffffffffffff);
            UNIT_ASSERT_EQUAL(proto.GetV1(), 0xffffffffffffffff);
            UNIT_ASSERT_EQUAL(proto.GetV2(), 0xffffffffffffffff);
            UNIT_ASSERT_EQUAL(proto.GetV3(), 0xffffffffffffffff);
        }

        {
            // test all 0 min value
            auto proto = HexToUInt256(
                "00000000000000000000000000000000"
                "00000000000000000000000000000000"
            );
            UNIT_ASSERT_EQUAL(proto.GetV0(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV1(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV2(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV3(), 0x0);
        }

        {
            // test half/half some value
            auto proto = HexToUInt256(
                "0000000000000000ffffffffffffffff"
                "0000000000000000ffffffffffffffff"
            );
            UNIT_ASSERT_EQUAL(proto.GetV0(), 0xffffffffffffffff);
            UNIT_ASSERT_EQUAL(proto.GetV1(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV2(), 0xffffffffffffffff);
            UNIT_ASSERT_EQUAL(proto.GetV3(), 0x0);
        }

        {
            // test half/half some value
            auto proto = HexToUInt256(
                "ffffffffffffffff0000000000000000"
                "ffffffffffffffff0000000000000000"
            );
            UNIT_ASSERT_EQUAL(proto.GetV0(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV1(), 0xffffffffffffffff);
            UNIT_ASSERT_EQUAL(proto.GetV2(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV3(), 0xffffffffffffffff);
        }

        {
            // test random value
            auto proto = HexToUInt256(
                "E9800998ECF8427E-D41D8CD98F00B204"
                "D41D8CD98F00B204-E9800998ECF8427E"
            );
            UNIT_ASSERT_EQUAL(proto.GetV0(), 0xe9800998ecf8427e);
            UNIT_ASSERT_EQUAL(proto.GetV1(), 0xd41d8cd98f00b204);
            UNIT_ASSERT_EQUAL(proto.GetV2(), 0xd41d8cd98f00b204);
            UNIT_ASSERT_EQUAL(proto.GetV3(), 0xe9800998ecf8427e);
        }

        {
            // some more random test
            auto proto = HexToUInt256(
                "B16B00B5-dabbad00-00001234-BAADA555"
                "B16B00B5-00000000-faceFACE-b00cb00B"
            );
            UNIT_ASSERT_EQUAL(proto.GetV0(), 0xfacefaceb00cb00b);
            UNIT_ASSERT_EQUAL(proto.GetV1(), 0xB16B00B500000000);
            UNIT_ASSERT_EQUAL(proto.GetV2(), 0x1234baada555);
            UNIT_ASSERT_EQUAL(proto.GetV3(), 0xb16b00b5dabbad00);
        }

        {
            // and last one test
            auto proto = HexToUInt256(
                "00000000-12345678-90ABCDEF-00000000"
                "00000000-FEDCBA09-87654321-00000000"
            );
            UNIT_ASSERT_EQUAL(proto.GetV0(), 0x8765432100000000);
            UNIT_ASSERT_EQUAL(proto.GetV1(), 0x00000000fedcba09);
            UNIT_ASSERT_EQUAL(proto.GetV2(), 0x90abcdef00000000);
            UNIT_ASSERT_EQUAL(proto.GetV3(), 0x12345678);
        }
    }

    Y_UNIT_TEST(TEST_cast_to_uint64) {
        // should check is correct convert string to uin64
        {
            auto value = static_cast<ui64>(NIdentifiers::TYandexuid(
                "123456789"
            ));
            UNIT_ASSERT_EQUAL(value, 123456789);
        }
        {
            auto value = static_cast<ui64>(NIdentifiers::TYandexuid(
                "invalid"
            ));
            UNIT_ASSERT_EQUAL(value, 0);
        }
    }

    Y_UNIT_TEST(TEST_cast_to_uint128) {
        // should check is correct convert hexdigest string to uin256
        {
            // test all F max value
            auto proto = static_cast<NCrypta::NIdentifiersProto::UInt256>(NIdentifiers::TGaid(
                "ffff-FFFF-ffff-FFFF-ffff-FFFF-ffff-FFFF"
            ));
            UNIT_ASSERT_EQUAL(proto.GetV0(), 0xffffffffffffffff);
            UNIT_ASSERT_EQUAL(proto.GetV1(), 0xffffffffffffffff);
            UNIT_ASSERT_EQUAL(proto.GetV2(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV3(), 0x0);
        }

        {
            // test all 0 min value
            auto proto = static_cast<NCrypta::NIdentifiersProto::UInt256>(NIdentifiers::TGaid(
                "00000000000000000000000000000000"
            ));
            UNIT_ASSERT_EQUAL(proto.GetV0(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV1(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV2(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV3(), 0x0);
        }

        {
            // test half/half some value
            auto proto = static_cast<NCrypta::NIdentifiersProto::UInt256>(NIdentifiers::TGaid(
                "0000000000000000ffffffffffffffff"
            ));
            UNIT_ASSERT_EQUAL(proto.GetV0(), 0xffffffffffffffff);
            UNIT_ASSERT_EQUAL(proto.GetV1(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV2(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV3(), 0x0);
        }

        {
            // test half/half some value
            auto proto = static_cast<NCrypta::NIdentifiersProto::UInt256>(NIdentifiers::TGaid(
                "ffffffffffffffff0000000000000000"
            ));
            UNIT_ASSERT_EQUAL(proto.GetV0(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV1(), 0xffffffffffffffff);
            UNIT_ASSERT_EQUAL(proto.GetV2(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV3(), 0x0);
        }

        {
            // test random value
            auto proto = static_cast<NCrypta::NIdentifiersProto::UInt256>(NIdentifiers::TGaid(
                "D41D8CD98F00B204-E9800998ECF8427E"
            ));
            UNIT_ASSERT_EQUAL(proto.GetV0(), 0xe9800998ecf8427e);
            UNIT_ASSERT_EQUAL(proto.GetV1(), 0xd41d8cd98f00b204);
            UNIT_ASSERT_EQUAL(proto.GetV2(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV3(), 0x0);
        }

        {
            // some more random test
            auto proto = static_cast<NCrypta::NIdentifiersProto::UInt256>(NIdentifiers::TGaid(
                "B16B00B5-00000000-faceFACE-b00cb00B"
            ));
            UNIT_ASSERT_EQUAL(proto.GetV0(), 0xfacefaceb00cb00b);
            UNIT_ASSERT_EQUAL(proto.GetV1(), 0xB16B00B500000000);
            UNIT_ASSERT_EQUAL(proto.GetV2(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV3(), 0x0);
        }

        {
            // and last one test
            auto proto = static_cast<NCrypta::NIdentifiersProto::UInt256>(NIdentifiers::TGaid(
                "00000000-FEDCBA09-87654321-00000000"
            ));
            UNIT_ASSERT_EQUAL(proto.GetV0(), 0x8765432100000000);
            UNIT_ASSERT_EQUAL(proto.GetV1(), 0x00000000fedcba09);
            UNIT_ASSERT_EQUAL(proto.GetV2(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV3(), 0x0);
        }
    }

    Y_UNIT_TEST(TEST_cast_to_uint256) {
        // should check is correct convert hexdigest string to uin256
        {
            // test is no ovefrlow on ui64
            auto value = static_cast<ui64>(NIdentifiers::TSha256(
                "ffff-FFFF-ffff-FFFF-ffff-FFFF-ffff-FFFF"
                "ffff-FFFF-ffff-FFFF-ffff-FFFF-ffff-FFFF"
            ));
            UNIT_ASSERT_EQUAL(value, 0);
        }
        {
            // test all F max value
            auto proto = static_cast<NCrypta::NIdentifiersProto::UInt256>(NIdentifiers::TSha256(
                "ffff-FFFF-ffff-FFFF-ffff-FFFF-ffff-FFFF"
                "ffff-FFFF-ffff-FFFF-ffff-FFFF-ffff-FFFF"
            ));
            UNIT_ASSERT_EQUAL(proto.GetV0(), 0xffffffffffffffff);
            UNIT_ASSERT_EQUAL(proto.GetV1(), 0xffffffffffffffff);
            UNIT_ASSERT_EQUAL(proto.GetV2(), 0xffffffffffffffff);
            UNIT_ASSERT_EQUAL(proto.GetV3(), 0xffffffffffffffff);
        }
        {
            // test all 0 min value
            auto proto = static_cast<NCrypta::NIdentifiersProto::UInt256>(NIdentifiers::TSha256(
                "00000000000000000000000000000000"
                "00000000000000000000000000000000"
            ));
            UNIT_ASSERT_EQUAL(proto.GetV0(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV1(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV2(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV3(), 0x0);
        }

        {
            // test half/half some value
            auto proto = static_cast<NCrypta::NIdentifiersProto::UInt256>(NIdentifiers::TSha256(
                "0000000000000000ffffffffffffffff"
                "0000000000000000ffffffffffffffff"
            ));
            UNIT_ASSERT_EQUAL(proto.GetV0(), 0xffffffffffffffff);
            UNIT_ASSERT_EQUAL(proto.GetV1(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV2(), 0xffffffffffffffff);
            UNIT_ASSERT_EQUAL(proto.GetV3(), 0x0);
        }

        {
            // test half/half some value
            auto proto = static_cast<NCrypta::NIdentifiersProto::UInt256>(NIdentifiers::TSha256(
                "ffffffffffffffff0000000000000000"
                "ffffffffffffffff0000000000000000"
            ));
            UNIT_ASSERT_EQUAL(proto.GetV0(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV1(), 0xffffffffffffffff);
            UNIT_ASSERT_EQUAL(proto.GetV2(), 0x0);
            UNIT_ASSERT_EQUAL(proto.GetV3(), 0xffffffffffffffff);
        }

        {
            // test random value
            auto proto = static_cast<NCrypta::NIdentifiersProto::UInt256>(NIdentifiers::TSha256(
                "E9800998ECF8427E-D41D8CD98F00B204"
                "D41D8CD98F00B204-E9800998ECF8427E"
            ));
            UNIT_ASSERT_EQUAL(proto.GetV0(), 0xe9800998ecf8427e);
            UNIT_ASSERT_EQUAL(proto.GetV1(), 0xd41d8cd98f00b204);
            UNIT_ASSERT_EQUAL(proto.GetV2(), 0xd41d8cd98f00b204);
            UNIT_ASSERT_EQUAL(proto.GetV3(), 0xe9800998ecf8427e);
        }

        {
            // some more random test
            auto proto = static_cast<NCrypta::NIdentifiersProto::UInt256>(NIdentifiers::TSha256(
                "B16B00B5-dabbad00-00001234-BAADA555"
                "B16B00B5-00000000-faceFACE-b00cb00B"
            ));
            UNIT_ASSERT_EQUAL(proto.GetV0(), 0xfacefaceb00cb00b);
            UNIT_ASSERT_EQUAL(proto.GetV1(), 0xB16B00B500000000);
            UNIT_ASSERT_EQUAL(proto.GetV2(), 0x1234baada555);
            UNIT_ASSERT_EQUAL(proto.GetV3(), 0xb16b00b5dabbad00);
        }

        {
            // and last one test
            auto proto = static_cast<NCrypta::NIdentifiersProto::UInt256>(NIdentifiers::TSha256(
                "00000000-12345678-90ABCDEF-00000000"
                "00000000-FEDCBA09-87654321-00000000"
            ));
            UNIT_ASSERT_EQUAL(proto.GetV0(), 0x8765432100000000);
            UNIT_ASSERT_EQUAL(proto.GetV1(), 0x00000000fedcba09);
            UNIT_ASSERT_EQUAL(proto.GetV2(), 0x90abcdef00000000);
            UNIT_ASSERT_EQUAL(proto.GetV3(), 0x12345678);
        }
    }
}
