#include <iosfwd>

#include <crypta/lib/native/identifiers/lib/generic.h>
#include <crypta/lib/native/identifiers/lib/id_types/all.h>
#include <library/cpp/testing/unittest/registar.h>
#include <util/system/type_name.h>

Y_UNIT_TEST_SUITE(TestProtoIdentifierCorrect) {

    // uint64 values

    Y_UNIT_TEST(TEST_Phone_proto) {
        const TString id = NIdentifiers::TPhone::Next();
        const ui64 integer_id = FromString<ui64>(id.substr(1));

        auto identifier = NIdentifiers::TPhone(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::PHONE);
        UNIT_ASSERT(proto.HasPhone());
        UNIT_ASSERT_EQUAL(proto.GetPhone().GetValue(), integer_id);
    }

    Y_UNIT_TEST(TEST_AvitoId_proto) {
        const TString id = NIdentifiers::TAvitoId::Next();
        const ui64 integer_id = FromString<ui64>(id);

        auto identifier = NIdentifiers::TAvitoId(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::AVITO_ID);
        UNIT_ASSERT(proto.HasAvitoId());
        UNIT_ASSERT_EQUAL(proto.GetAvitoId().GetValue(), integer_id);
    }

    Y_UNIT_TEST(TEST_CryptaId_proto) {
        const TString id = NIdentifiers::TCryptaId::Next();
        const ui64 integer_id = FromString<ui64>(id);

        auto identifier = NIdentifiers::TCryptaId(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::CRYPTA_ID);
        UNIT_ASSERT(proto.HasCryptaId());
        UNIT_ASSERT_EQUAL(proto.GetCryptaId().GetValue(), integer_id);
    }

    Y_UNIT_TEST(TEST_FbId_proto) {
        const TString id = NIdentifiers::TFbId::Next();
        const ui64 integer_id = FromString<ui64>(id);

        auto identifier = NIdentifiers::TFbId(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::FB_ID);
        UNIT_ASSERT(proto.HasFbId());
        UNIT_ASSERT_EQUAL(proto.GetFbId().GetValue(), integer_id);
    }

    Y_UNIT_TEST(TEST_Icookie_proto) {
        const TString id = NIdentifiers::TIcookie::Next();
        const ui64 integer_id = FromString<ui64>(id);

        auto identifier = NIdentifiers::TIcookie(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::ICOOKIE);
        UNIT_ASSERT(proto.HasIcookie());
        UNIT_ASSERT_EQUAL(proto.GetIcookie().GetValue(), integer_id);
    }

    Y_UNIT_TEST(TEST_KpId_proto) {
        const TString id = NIdentifiers::TKpId::Next();
        const ui64 integer_id = FromString<ui64>(id);

        auto identifier = NIdentifiers::TKpId(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::KINOPOISK_ID);
        UNIT_ASSERT(proto.HasKpId());
        UNIT_ASSERT_EQUAL(proto.GetKpId().GetValue(), integer_id);
    }

    Y_UNIT_TEST(TEST_Mac_proto) {
        const TString id = NIdentifiers::TMac::Next();
        TString value = id;
        SubstGlobal(value, ":", "", 0);
        const ui64 integer_id = IntFromString<ui64, 16>(value);

        auto identifier = NIdentifiers::TMac(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::MAC);
        UNIT_ASSERT(proto.HasMac());
        UNIT_ASSERT_EQUAL(proto.GetMac().GetValue(), integer_id);
    }

    Y_UNIT_TEST(TEST_MmDeviceIdHash_proto) {
        const TString id = NIdentifiers::TMmDeviceIdHash::Next();
        const ui64 integer_id = FromString<ui64>(id);

        auto identifier = NIdentifiers::TMmDeviceIdHash(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::MM_DEVICE_ID_HASH);
        UNIT_ASSERT(proto.HasMmDeviceIdHash());
        UNIT_ASSERT_EQUAL(proto.GetMmDeviceIdHash().GetValue(), integer_id);
    }

    Y_UNIT_TEST(TEST_OkId_proto) {
        const TString id = NIdentifiers::TOkId::Next();
        const ui64 integer_id = FromString<ui64>(id);

        auto identifier = NIdentifiers::TOkId(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::OK_ID);
        UNIT_ASSERT(proto.HasOkId());
        UNIT_ASSERT_EQUAL(proto.GetOkId().GetValue(), integer_id);
    }

    Y_UNIT_TEST(TEST_Puid_proto) {
        const TString id = NIdentifiers::TPuid::Next();
        const ui64 integer_id = FromString<ui64>(id);

        auto identifier = NIdentifiers::TPuid(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::PUID);
        UNIT_ASSERT(proto.HasPuid());
        UNIT_ASSERT_EQUAL(proto.GetPuid().GetValue(), integer_id);
    }

    Y_UNIT_TEST(TEST_DirectClientId_proto) {
        const TString id = NIdentifiers::TDirectClientId::Next();
        const ui64 integer_id = FromString<ui64>(id);

        auto identifier = NIdentifiers::TDirectClientId(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::DIRECT_CLIENT_ID);
        UNIT_ASSERT(proto.HasDirectClientId());
        UNIT_ASSERT_EQUAL(proto.GetDirectClientId().GetValue(), integer_id);
    }

    Y_UNIT_TEST(TEST_XUniqGuid_proto) {
        const TString id = NIdentifiers::TXUniqGuid::Next();
        const ui64 integer_id = FromString<ui64>(id);

        auto identifier = NIdentifiers::TXUniqGuid(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::XUNIQ_GUID);
        UNIT_ASSERT(proto.HasXUniqGuid());
        UNIT_ASSERT_EQUAL(proto.GetXUniqGuid().GetValue(), integer_id);
    }

    Y_UNIT_TEST(TEST_YamoneyId_proto) {
        const TString id = NIdentifiers::TYamoneyId::Next();
        const ui64 integer_id = FromString<ui64>(id);

        auto identifier = NIdentifiers::TYamoneyId(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::YAMONEY_ID);
        UNIT_ASSERT(proto.HasYamoneyId());
        UNIT_ASSERT_EQUAL(proto.GetYamoneyId().GetValue(), integer_id);
    }

    Y_UNIT_TEST(TEST_Yandexuid_proto) {
        const TString id = NIdentifiers::TYandexuid::Next();
        const ui64 integer_id = FromString<ui64>(id);

        auto identifier = NIdentifiers::TYandexuid(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::YANDEXUID);
        UNIT_ASSERT(proto.HasYandexuid());
        UNIT_ASSERT_EQUAL(proto.GetYandexuid().GetValue(), integer_id);
    }

    // string value

    Y_UNIT_TEST(TEST_DistrR1_proto) {
        const TString id = NIdentifiers::TDistrR1::Next();
        auto identifier = NIdentifiers::TDistrR1(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::DISTR_R1);
        UNIT_ASSERT(proto.HasDistrR1());
        UNIT_ASSERT_EQUAL(proto.GetDistrR1().GetValue(), id);
    }

    Y_UNIT_TEST(TEST_Email_proto) {
        const TString id = NIdentifiers::TEmail::Next();
        auto identifier = NIdentifiers::TEmail(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::EMAIL);
        UNIT_ASSERT(proto.HasEmail());

        size_t at_position = id.find("@", 0);
        TString login = id.substr(0, at_position);
        TString domain = id.substr(at_position + 1);
        // no @ in domain and Login
        UNIT_ASSERT_EQUAL(login.find("@", 0), TString::npos);
        UNIT_ASSERT_EQUAL(domain.find("@", 0), TString::npos);

        UNIT_ASSERT_EQUAL(proto.GetEmail().GetLogin(), login);
        UNIT_ASSERT_EQUAL(proto.GetEmail().GetDomain(), domain);
    }

    Y_UNIT_TEST(TEST_Login_proto) {
        const TString id = NIdentifiers::TLogin::Next();
        auto identifier = NIdentifiers::TLogin(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::LOGIN);
        UNIT_ASSERT(proto.HasLogin());
        UNIT_ASSERT_EQUAL(proto.GetLogin().GetValue(), id);
    }

    Y_UNIT_TEST(TEST_PartnerRecordId_proto) {
        const TString id = NIdentifiers::TPartnerRecordId::Next();
        auto identifier = NIdentifiers::TPartnerRecordId(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::PARTNER_ID);
        UNIT_ASSERT(proto.HasPartnerRecordId());
        UNIT_ASSERT_EQUAL(proto.GetPartnerRecordId().GetValue(), id);
    }

    Y_UNIT_TEST(TEST_VkId_proto) {
        const TString id = NIdentifiers::TVkId::Next();
        auto identifier = NIdentifiers::TVkId(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::VK_ID);
        UNIT_ASSERT(proto.HasVkId());
        UNIT_ASSERT_EQUAL(proto.GetVkId().GetValue(), id);
    }

    // uint128

    Y_UNIT_TEST(TEST_AvitoHash_proto) {
        const TString id = NIdentifiers::TAvitoHash::Next();
        auto identifier = NIdentifiers::TAvitoHash(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::AVITO_HASH);
        UNIT_ASSERT(proto.HasAvitoHash());

        auto big_int = HexToUInt128(id);
        UNIT_ASSERT_EQUAL(proto.GetAvitoHash().GetValue().GetLo(), big_int.GetLo());
        UNIT_ASSERT_EQUAL(proto.GetAvitoHash().GetValue().GetHi(), big_int.GetHi());
    }

    Y_UNIT_TEST(TEST_DistrUI_proto) {
        const TString id = NIdentifiers::TDistrUI::Next();
        auto identifier = NIdentifiers::TDistrUI(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::DISTR_UI);
        UNIT_ASSERT(proto.HasDistrUI());

        auto big_int = HexToUInt128(id);
        UNIT_ASSERT_EQUAL(proto.GetDistrUI().GetValue().GetLo(), big_int.GetLo());
        UNIT_ASSERT_EQUAL(proto.GetDistrUI().GetValue().GetHi(), big_int.GetHi());
    }

    Y_UNIT_TEST(TEST_DitId_proto) {
        const TString id = NIdentifiers::TDitId::Next();
        auto identifier = NIdentifiers::TDitId(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::DIT_ID);
        UNIT_ASSERT(proto.HasDitId());

        auto big_int = HexToUInt128(id);
        UNIT_ASSERT_EQUAL(proto.GetDitId().GetValue().GetLo(), big_int.GetLo());
        UNIT_ASSERT_EQUAL(proto.GetDitId().GetValue().GetHi(), big_int.GetHi());
    }

    Y_UNIT_TEST(TEST_Duid_proto) {
        const TString id = NIdentifiers::TDuid::Next();
        const ui64 integer_id = FromString<ui64>(id);

        auto identifier = NIdentifiers::TDuid(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::DUID);
        UNIT_ASSERT(proto.HasDuid());
        UNIT_ASSERT_EQUAL(proto.GetDuid().GetValue(), integer_id);
    }

    Y_UNIT_TEST(TEST_Gaid_proto) {
        const TString id = NIdentifiers::TGaid::Next();
        auto identifier = NIdentifiers::TGaid(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::GAID);
        UNIT_ASSERT(proto.HasGaid());

        auto big_int = HexToUInt128(id);
        UNIT_ASSERT_EQUAL(proto.GetGaid().GetValue().GetLo(), big_int.GetLo());
        UNIT_ASSERT_EQUAL(proto.GetGaid().GetValue().GetHi(), big_int.GetHi());
    }

    Y_UNIT_TEST(TEST_Idfa_proto) {
        const TString id = NIdentifiers::TIdfa::Next();
        auto identifier = NIdentifiers::TIdfa(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::IDFA);
        UNIT_ASSERT(proto.HasIdfa());

        auto big_int = HexToUInt128(id);
        UNIT_ASSERT_EQUAL(proto.GetIdfa().GetValue().GetLo(), big_int.GetLo());
        UNIT_ASSERT_EQUAL(proto.GetIdfa().GetValue().GetHi(), big_int.GetHi());
    }

    Y_UNIT_TEST(TEST_Ifv_proto) {
        const TString id = NIdentifiers::TIfv::Next();
        auto identifier = NIdentifiers::TIfv(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::IFV);
        UNIT_ASSERT(proto.HasIfv());

        auto big_int = HexToUInt128(id);
        UNIT_ASSERT_EQUAL(proto.GetIfv().GetValue().GetLo(), big_int.GetLo());
        UNIT_ASSERT_EQUAL(proto.GetIfv().GetValue().GetHi(), big_int.GetHi());
    }

    Y_UNIT_TEST(TEST_IdfaGaid_proto) {
        const TString id = NIdentifiers::TIdfaGaid::Next();
        auto identifier = NIdentifiers::TIdfaGaid(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::IDFA_GAID);
        UNIT_ASSERT(proto.HasIdfa() || proto.HasGaid());

        auto proto_value = proto.HasIdfa() ? proto.GetIdfa().GetValue()
                                           : proto.GetGaid().GetValue();

        auto big_int = HexToUInt128(id);
        UNIT_ASSERT_EQUAL(proto_value.GetLo(), big_int.GetLo());
        UNIT_ASSERT_EQUAL(proto_value.GetHi(), big_int.GetHi());
    }

    Y_UNIT_TEST(TEST_Md5_proto) {
        const TString id = NIdentifiers::TMd5::Next();
        auto identifier = NIdentifiers::TMd5(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::MD5);
        UNIT_ASSERT(proto.HasMd5());

        auto big_int = HexToUInt128(id);
        UNIT_ASSERT_EQUAL(proto.GetMd5().GetValue().GetLo(), big_int.GetLo());
        UNIT_ASSERT_EQUAL(proto.GetMd5().GetValue().GetHi(), big_int.GetHi());
    }

    Y_UNIT_TEST(TEST_EmailMd5_proto) {
        const TString id = NIdentifiers::TEmailMd5::Next();
        auto identifier = NIdentifiers::TEmailMd5(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::EMAIL_MD5);
        UNIT_ASSERT(proto.HasMd5());

        auto big_int = HexToUInt128(id);
        UNIT_ASSERT_EQUAL(proto.GetMd5().GetValue().GetLo(), big_int.GetLo());
        UNIT_ASSERT_EQUAL(proto.GetMd5().GetValue().GetHi(), big_int.GetHi());
    }

    Y_UNIT_TEST(TEST_PhoneMd5_proto) {
        const TString id = NIdentifiers::TPhoneMd5::Next();
        auto identifier = NIdentifiers::TPhoneMd5(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::PHONE_MD5);
        UNIT_ASSERT(proto.HasMd5());

        auto big_int = HexToUInt128(id);
        UNIT_ASSERT_EQUAL(proto.GetMd5().GetValue().GetLo(), big_int.GetLo());
        UNIT_ASSERT_EQUAL(proto.GetMd5().GetValue().GetHi(), big_int.GetHi());
    }

    Y_UNIT_TEST(TEST_MacExtMd5_proto) {
        const TString id = NIdentifiers::TMacExtMd5::Next();
        auto identifier = NIdentifiers::TMacExtMd5(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::MAC_EXT_MD5);
        UNIT_ASSERT(proto.HasMd5());

        auto big_int = HexToUInt128(id);
        UNIT_ASSERT_EQUAL(proto.GetMd5().GetValue().GetLo(), big_int.GetLo());
        UNIT_ASSERT_EQUAL(proto.GetMd5().GetValue().GetHi(), big_int.GetHi());
    }

    Y_UNIT_TEST(TEST_MmDeviceId_proto) {
        const TString id = NIdentifiers::TMmDeviceId::Next();
        auto identifier = NIdentifiers::TMmDeviceId(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::MM_DEVICE_ID);
        UNIT_ASSERT(proto.HasMmDeviceId());

        auto big_int = HexToUInt128(identifier.Normalize());
        UNIT_ASSERT_EQUAL(proto.GetMmDeviceId().GetValue().GetLo(), big_int.GetLo());
        UNIT_ASSERT_EQUAL(proto.GetMmDeviceId().GetValue().GetHi(), big_int.GetHi());
    }

    Y_UNIT_TEST(TEST_Uuid_proto) {
        const TString id = NIdentifiers::TUuid::Next();
        auto identifier = NIdentifiers::TUuid(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::UUID);
        UNIT_ASSERT(proto.HasUuid());

        auto big_int = HexToUInt128(id);
        UNIT_ASSERT_EQUAL(proto.GetUuid().GetValue().GetLo(), big_int.GetLo());
        UNIT_ASSERT_EQUAL(proto.GetUuid().GetValue().GetHi(), big_int.GetHi());
    }

    // uint256

    Y_UNIT_TEST(TEST_Sha256_proto) {
        const TString id = NIdentifiers::TSha256::Next();
        auto identifier = NIdentifiers::TSha256(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::SHA256);
        UNIT_ASSERT(proto.HasSha256());

        auto big_int = HexToUInt256(id);
        UNIT_ASSERT_EQUAL(proto.GetSha256().GetValue().GetV0(), big_int.GetV0());
        UNIT_ASSERT_EQUAL(proto.GetSha256().GetValue().GetV1(), big_int.GetV1());
        UNIT_ASSERT_EQUAL(proto.GetSha256().GetValue().GetV2(), big_int.GetV2());
        UNIT_ASSERT_EQUAL(proto.GetSha256().GetValue().GetV3(), big_int.GetV3());
    }

    Y_UNIT_TEST(TEST_EmailSha256_proto) {
        const TString id = NIdentifiers::TEmailSha256::Next();
        auto identifier = NIdentifiers::TEmailSha256(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::EMAIL_SHA256);
        UNIT_ASSERT(proto.HasSha256());

        auto big_int = HexToUInt256(id);
        UNIT_ASSERT_EQUAL(proto.GetSha256().GetValue().GetV0(), big_int.GetV0());
        UNIT_ASSERT_EQUAL(proto.GetSha256().GetValue().GetV1(), big_int.GetV1());
        UNIT_ASSERT_EQUAL(proto.GetSha256().GetValue().GetV2(), big_int.GetV2());
        UNIT_ASSERT_EQUAL(proto.GetSha256().GetValue().GetV3(), big_int.GetV3());
    }

    Y_UNIT_TEST(TEST_PhoneSha256_proto) {
        const TString id = NIdentifiers::TPhoneSha256::Next();
        auto identifier = NIdentifiers::TPhoneSha256(id);
        NCrypta::NIdentifiersProto::TGenericID proto(identifier.ToProto());

        UNIT_ASSERT_EQUAL(proto.GetType(), NCrypta::NIdentifiersProto::NIdType::PHONE_SHA256);
        UNIT_ASSERT(proto.HasSha256());

        auto big_int = HexToUInt256(id);
        UNIT_ASSERT_EQUAL(proto.GetSha256().GetValue().GetV0(), big_int.GetV0());
        UNIT_ASSERT_EQUAL(proto.GetSha256().GetValue().GetV1(), big_int.GetV1());
        UNIT_ASSERT_EQUAL(proto.GetSha256().GetValue().GetV2(), big_int.GetV2());
        UNIT_ASSERT_EQUAL(proto.GetSha256().GetValue().GetV3(), big_int.GetV3());
    }
}


Y_UNIT_TEST_SUITE(TestProtoConstructor) {

    template <class Identifier>
    NCrypta::NIdentifiersProto::TGenericID TestIdentifierConstruct() {
        const TString id = Identifier::Next();
        const auto identifier_str = Identifier(id);  // construct from string
        auto proto = identifier_str.ToProto();
        // create from proto
        const auto identifier_proto = Identifier(proto);

        // Cerr << "Check " << TypeName<Identifier>() << "\n"
        //      << "orig. id: " << id << "\n"
        //      << "proto id: " << identifier_proto.Normalize() << "\n";

        UNIT_ASSERT(identifier_proto.IsValid());
        UNIT_ASSERT_EQUAL(identifier_proto.Normalize(), id);
        UNIT_ASSERT_EQUAL(identifier_proto.Normalize(), identifier_str.Normalize());
        UNIT_ASSERT_EQUAL(identifier_proto.GetType(), proto.GetType());
        return identifier_proto.ToProto();
    }

    // 64 bits integer

    Y_UNIT_TEST(TEST_Phone_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TPhone>();
        UNIT_ASSERT(proto.HasPhone());
    }

    Y_UNIT_TEST(TEST_AvitoId_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TAvitoId>();
        UNIT_ASSERT(proto.HasAvitoId());
    }

    Y_UNIT_TEST(TEST_CryptaId_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TCryptaId>();
        UNIT_ASSERT(proto.HasCryptaId());
    }

    Y_UNIT_TEST(TEST_FbId_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TFbId>();
        UNIT_ASSERT(proto.HasFbId());
    }

    Y_UNIT_TEST(TEST_Icookie_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TIcookie>();
        UNIT_ASSERT(proto.HasIcookie());
    }

    Y_UNIT_TEST(TEST_KpId_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TKpId>();
        UNIT_ASSERT(proto.HasKpId());
    }

    Y_UNIT_TEST(TEST_Mac_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TMac>();
        UNIT_ASSERT(proto.HasMac());
    }

    Y_UNIT_TEST(TEST_MacExt_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TMacExt>();
        UNIT_ASSERT(proto.HasMac());
    }

    Y_UNIT_TEST(TEST_MmDeviceIdHash_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TMmDeviceIdHash>();
        UNIT_ASSERT(proto.HasMmDeviceIdHash());
    }

    Y_UNIT_TEST(TEST_OkId_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TOkId>();
        UNIT_ASSERT(proto.HasOkId());
    }

    Y_UNIT_TEST(TEST_Puid_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TPuid>();
        UNIT_ASSERT(proto.HasPuid());
    }

    Y_UNIT_TEST(TEST_XUniqGuid_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TXUniqGuid>();
        UNIT_ASSERT(proto.HasXUniqGuid());
    }

    Y_UNIT_TEST(TEST_YamoneyId_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TYamoneyId>();
        UNIT_ASSERT(proto.HasYamoneyId());
    }

    Y_UNIT_TEST(TEST_Yandexuid_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TYandexuid>();
        UNIT_ASSERT(proto.HasYandexuid());
    }

    Y_UNIT_TEST(TEST_AndroidId_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TAndroidId>();
        UNIT_ASSERT(proto.HasAndroidId());
    }

    // strings

    Y_UNIT_TEST(TEST_DistrR1_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TDistrR1>();
        UNIT_ASSERT(proto.HasDistrR1());
    }

    Y_UNIT_TEST(TEST_Email_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TEmail>();
        UNIT_ASSERT(proto.HasEmail());
    }

    Y_UNIT_TEST(TEST_Login_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TLogin>();
        UNIT_ASSERT(proto.HasLogin());
    }

    Y_UNIT_TEST(TEST_PartnerRecordId_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TPartnerRecordId>();
        UNIT_ASSERT(proto.HasPartnerRecordId());
    }

    Y_UNIT_TEST(TEST_VkId_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TVkId>();
        UNIT_ASSERT(proto.HasVkId());
    }

    Y_UNIT_TEST(TEST_Imei_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TImei>();
        UNIT_ASSERT(proto.HasImei());
    }

    Y_UNIT_TEST(TEST_VkName_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TVkName>();
        UNIT_ASSERT(proto.HasVkName());
    }

    // 128 bits integer

    Y_UNIT_TEST(TEST_AvitoHash_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TAvitoHash>();
        UNIT_ASSERT(proto.HasAvitoHash());
    }

    Y_UNIT_TEST(TEST_distr_ui_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TDistrUI>();
        UNIT_ASSERT(proto.HasDistrUI());
    }

    Y_UNIT_TEST(TEST_DitId_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TDitId>();
        UNIT_ASSERT(proto.HasDitId());
    }

    Y_UNIT_TEST(TEST_Gaid_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TGaid>();
        UNIT_ASSERT(proto.HasGaid());
    }

    Y_UNIT_TEST(TEST_Idfa_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TIdfa>();
        UNIT_ASSERT(proto.HasIdfa());
    }

    Y_UNIT_TEST(TEST_IdfaGaid_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TIdfaGaid>();
        UNIT_ASSERT(proto.HasIdfa() || proto.HasGaid());
    }

    Y_UNIT_TEST(TEST_Md5_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TMd5>();
        UNIT_ASSERT(proto.HasMd5());
    }

    Y_UNIT_TEST(TEST_MmDeviceId_proto_constructor) {
        // MmDeviceId may be UPPER lower UPPER-DASHES and lower-dashes (so proto recover ALl to lower)
        // TODO: may be we need to store information about what MMDEVICEID case used in dumps
        TString id = to_lower(NIdentifiers::TMmDeviceId::Next());
        SubstGlobal(id, "-", "", 0);

        const auto identifier_str = NIdentifiers::TMmDeviceId(id);  // construct from string
        auto proto = identifier_str.ToProto();
        // create from proto
        const auto identifier_proto = NIdentifiers::TMmDeviceId(proto);

        // Cerr << "Check " << TypeName<NIdentifiers::TMmDeviceId>() << "\n"
        //      << "orig. id: " << id << "\n"
        //      << "proto id: " << identifier_proto.Normalize() << "\n";

        UNIT_ASSERT(identifier_proto.IsValid());
        if (id.size() == 24) {
            id = "00000000" + id;
        }
        UNIT_ASSERT_EQUAL(identifier_proto.Normalize(), id);
        UNIT_ASSERT_EQUAL(identifier_proto.Normalize(), identifier_str.Normalize());
        UNIT_ASSERT_EQUAL(identifier_proto.GetType(), proto.GetType());
        UNIT_ASSERT(proto.HasMmDeviceId());
    }

    Y_UNIT_TEST(TEST_Uuid_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TUuid>();
        UNIT_ASSERT(proto.HasUuid());
    }

    // 256 bits integer

    Y_UNIT_TEST(TEST_Sha256_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TSha256>();
        UNIT_ASSERT(proto.HasSha256());
    }

    Y_UNIT_TEST(TEST_YSClid_proto_constructor) {
        auto proto = TestIdentifierConstruct<NIdentifiers::TYSClid>();
        UNIT_ASSERT(proto.HasYSClid());
    }
}
