#include <iosfwd>

#include "helpers.h"

#include <crypta/lib/native/identifiers/lib/generic.h>
#include <crypta/lib/native/identifiers/lib/id_types/all.h>

#include <google/protobuf/util/message_differencer.h>
#include <library/cpp/testing/unittest/registar.h>
#include <util/generic/hash.h>

template <class TypeIdentifier>
void SerializeInvalidTest() {
    const TString value{"!@#$%^&*()invalid"};
    const TypeIdentifier typed{value};
    const NIdentifiers::TGenericID generic{typed.GetType(), value};
    UNIT_ASSERT(!typed.IsValid());

    UNIT_ASSERT(google::protobuf::util::MessageDifferencer::Equals(typed.ToProto(), generic.ToProto()));
    UNIT_ASSERT(typed.ToProto().HasRawValue());
    UNIT_ASSERT_EQUAL(typed.ToProto().GetRawValue(), value);

    UNIT_ASSERT_EQUAL(TypeIdentifier(typed.ToProto()).Value(), value);
    UNIT_ASSERT_EQUAL(TypeIdentifier(typed.ToProto()).GetType(), typed.GetType());
    UNIT_ASSERT_EQUAL(NIdentifiers::TGenericID(typed.ToProto()).GetValue(), value);
    UNIT_ASSERT_EQUAL(NIdentifiers::TGenericID(typed.ToProto()).GetType(), typed.GetType());
}

template <class TypeIdentifier>
void SerializeValidTest() {
    const TString value{TypeIdentifier::Next()};
    const TypeIdentifier typed{value};
    const NIdentifiers::TGenericID generic{typed.GetType(), value};
    UNIT_ASSERT(typed.IsValid());

    UNIT_ASSERT(google::protobuf::util::MessageDifferencer::Equals(typed.ToProto(), generic.ToProto()));
    UNIT_ASSERT(!typed.ToProto().HasRawValue());

    UNIT_ASSERT_EQUAL(TypeIdentifier(typed.ToProto()).Value(), value);
    UNIT_ASSERT_EQUAL(TypeIdentifier(typed.ToProto()).GetType(), typed.GetType());
    UNIT_ASSERT_EQUAL(NIdentifiers::TGenericID(typed.ToProto()).GetValue(), value);
    UNIT_ASSERT_EQUAL(NIdentifiers::TGenericID(typed.ToProto()).GetType(), typed.GetType());
}

template <>
void SerializeInvalidTest<NIdentifiers::TVkName>() {
    // vkid always valid, skip
    const TString value{"!@#$%^&*()invalid"};
    const NIdentifiers::TVkName typed{value};
    const NIdentifiers::TGenericID generic{typed.GetType(), value};
    UNIT_ASSERT(typed.IsValid());
}

template <>
void SerializeValidTest<NIdentifiers::TMmDeviceId>() {
    using TypeIdentifier = NIdentifiers::TMmDeviceId;
    TString value{to_lower(TypeIdentifier::Next())};
    SubstGlobal(value, "-", "", 0);

    if (value.size() == 24) {
        // leading zero case
        value.insert(0, "00000000");
    }

    const TypeIdentifier typed{value};
    const NIdentifiers::TGenericID generic{typed.GetType(), value};
    UNIT_ASSERT(typed.IsValid());

    UNIT_ASSERT(google::protobuf::util::MessageDifferencer::Equals(typed.ToProto(), generic.ToProto()));
    UNIT_ASSERT(!typed.ToProto().HasRawValue());

    UNIT_ASSERT_EQUAL(TypeIdentifier(typed.ToProto()).GetType(), typed.GetType());
    UNIT_ASSERT_EQUAL(TypeIdentifier(typed.ToProto()).Value(), value);
    UNIT_ASSERT_EQUAL(NIdentifiers::TGenericID(typed.ToProto()).GetType(), typed.GetType());
    UNIT_ASSERT_EQUAL(NIdentifiers::TGenericID(typed.ToProto()).GetValue(), value);
}

template <>
void SerializeInvalidTest<NIdentifiers::TIdfaGaid>() {
    // idfa-gaid is syntetic id which is can't be saved as invalid proto
}

Y_UNIT_TEST_SUITE(TestProtoIdentifier) {

#define TMP_TEST_MACRO(TIdType)                    \
    Y_UNIT_TEST(TEST_##TIdType##_Proto_Invalid) {  \
        using namespace NIdentifiers;              \
        SerializeInvalidTest< TIdType >();         \
    }                                              \
                                                   \
    Y_UNIT_TEST(TEST_##TIdType##_Proto_Valid) {    \
        using namespace NIdentifiers;              \
        SerializeValidTest< TIdType >();           \
    }

    APPLY_TMP_MACRO_FOR_ALL_ID_TYPES()
#undef TMP_TEST_MACRO

}
