#include <iosfwd>

#include "helpers.h"

#include <crypta/lib/native/identifiers/lib/generic.h>
#include <crypta/lib/native/identifiers/lib/id_types/all.h>
#include <library/cpp/string_utils/base64/base64.h>
#include <library/cpp/testing/unittest/registar.h>
#include <util/generic/hash.h>

template <class TypeIdentifier>
void SerializeTest() {
    THashMap<TypeIdentifier, size_t> map{};
    TString prev{};
    const auto Serialize{
        [](const TypeIdentifier& id){
            TString serialized;
            Y_PROTOBUF_SUPPRESS_NODISCARD id.ToProto().SerializeToString(&serialized);
            return Base64Encode(serialized);
        }
    };

    for (size_t index{0}; index < 10; ++index) {
        const TString next{TypeIdentifier::Next()};
        UNIT_ASSERT(prev != next);

        const TypeIdentifier first{next};
        const TypeIdentifier second{next};
        const NIdentifiers::TGenericID generic{first.GetType(), next};
        UNIT_ASSERT_EQUAL(Serialize(first), Serialize(second));
        UNIT_ASSERT_EQUAL(Serialize(first), Base64Encode(generic.Serialize()));
    }
}

Y_UNIT_TEST_SUITE(TestSerializedIdentifier) {

#define TMP_TEST_MACRO(TIdType)                     \
    Y_UNIT_TEST(TEST_##TIdType##_Hash_direct) {     \
        using namespace NIdentifiers;               \
        SerializeTest< TIdType >();                 \
    }

    APPLY_TMP_MACRO_FOR_ALL_ID_TYPES()
#undef TMP_TEST_MACRO

    Y_UNIT_TEST(TEST_Simple) {
        const NIdentifiers::TEmail email{"003i2r8a@yandex.ru"};
        const NIdentifiers::TGenericID generic{"email", "003i2r8a@yandex.ru"};
        const auto out{generic.Serialize()};

        TString serialized;
        Y_PROTOBUF_SUPPRESS_NODISCARD email.ToProto().SerializeToString(&serialized);
        UNIT_ASSERT_EQUAL(Base64Encode(serialized), Base64Encode(generic.Serialize()));
        UNIT_ASSERT_EQUAL(Base64Encode(serialized), "CAVCFQoIMDAzaTJyOGESCXlhbmRleC5ydQ==");
    }

}
