#pragma once

#include <library/cpp/threading/chunk_queue/queue.h>
#include <util/generic/hash.h>
#include <util/generic/string.h>

namespace NCrypta {
    template <typename TRequest, typename TReply>
    class TInprocBase {
    protected:
        using TClientId = size_t;

        struct TClientRequest {
            TClientRequest(const TClientId& clientId = TClientId(), const TRequest& request = TRequest())
                : ClientId(clientId), Request(request)
            {
            }

            TClientId ClientId;
            TRequest Request;
        };

        using TRequestsQueue = NThreading::TManyOneQueue<TClientRequest>;
        using TRepliesQueue = NThreading::TOneOneQueue<TReply>;
    };
}
