#pragma once

#include "base.h"

#include <library/cpp/threading/chunk_queue/queue.h>
#include <util/generic/noncopyable.h>
#include <util/generic/ptr.h>
#include <utility>

namespace NCrypta {
    template <typename TRequest, typename TReply>
    class TInprocClient : TInprocBase<TRequest, TReply>, TMoveOnly {
        using TBase = TInprocBase<TRequest, TReply>;
        using TRequestsQueue = typename TBase::TRequestsQueue;
        using TRepliesQueue = typename TBase::TRepliesQueue;

    public:
        using TClientId = typename TBase::TClientId;
        using TClientRequest = typename TBase::TClientRequest;

    public:
        TInprocClient(TClientId id, TRequestsQueue& requests, TRepliesQueue& replies)
            : Id(id)
            , Requests(requests)
            , Replies(replies)
        {
        }

        TClientId GetId() const {
            return Id;
        }

        void SendRequest(const TRequest& request) {
            Requests.Enqueue(TClientRequest(Id, request));
        }

        bool ReceiveReply(TReply& reply) {
            return Replies.Dequeue(reply);
        }

    private:
        TClientId Id;
        TRequestsQueue& Requests;
        TRepliesQueue& Replies;
    };
}
