#pragma once

#include "base.h"
#include "client.h"

#include <library/cpp/threading/chunk_queue/queue.h>
#include <util/generic/hash.h>
#include <util/generic/string.h>

namespace NCrypta {
    template <typename TRequest, typename TReply>
    class TInprocServer : TInprocBase<TRequest, TReply>, TNonCopyable {
        using TBase = TInprocBase<TRequest, TReply>;
        using TRequestsQueue = typename TBase::TRequestsQueue;
        using TRepliesQueue = typename TBase::TRepliesQueue;

    public:
        using TClientId = typename TBase::TClientId;
        using TClientRequest = typename TBase::TClientRequest;
        using TClient = TInprocClient<TRequest, TReply>;

        TInprocClient<TRequest, TReply> CreateClient() {
            auto clientId = LastClientId++;
            return TInprocClient<TRequest, TReply>(clientId, Requests, Replies[clientId]);
        }

        bool ReceiveRequest(TClientRequest& requestWithId) {
            return Requests.Dequeue(requestWithId);
        }

        void SendReply(TClientId clientId, const TReply& reply) {
            try {
                Replies.at(clientId).Enqueue(reply);
            } catch (const yexception&) {
                ythrow yexception() << "Wrong client id: " << clientId;
            }
        }

    private:
        using TRepliesQueues = THashMap<TClientId, TRepliesQueue>;

        TRequestsQueue Requests;
        TRepliesQueues Replies;
        TClientId LastClientId = 0;
    };
}
