#include <crypta/lib/native/inproc/server.h>

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TInproc) {
    using namespace NCrypta;

    Y_UNIT_TEST(SingleThreaded) {
        using TRequest = TString;
        using TReply = TString;
        using TServer = TInprocServer<TRequest, TReply>;

        TServer server;
        auto client = server.CreateClient();

        TServer::TClientRequest request;
        UNIT_ASSERT_C(!server.ReceiveRequest(request), "No messages on server before client send");

        auto requestStr = "Hello request";
        client.SendRequest(requestStr);

        UNIT_ASSERT(server.ReceiveRequest(request));
        UNIT_ASSERT_EQUAL(client.GetId(), request.ClientId);
        UNIT_ASSERT_EQUAL(requestStr, request.Request);

        UNIT_ASSERT_C(!server.ReceiveRequest(request), "No messages on server after receive");

        TString reply;
        UNIT_ASSERT_C(!client.ReceiveReply(reply), "No messages on client before server send");

        auto replyStr = "Hello reply";
        server.SendReply(request.ClientId, replyStr);

        UNIT_ASSERT(client.ReceiveReply(reply));
        UNIT_ASSERT_EQUAL(replyStr, reply);

        UNIT_ASSERT_C(!client.ReceiveReply(reply), "No messages on client after receive");

        Y_UNUSED(client);
    }
}
