#pragma once

#include "ip_filter_exceptions.h"

#include <library/cpp/ipmath/ipmath.h>
#include <library/cpp/ipv6_address/ipv6_address.h>
#include <util/generic/map.h>

namespace NCrypta {
    class TIpFilter {
    public:
        template <typename TCollection>
        explicit TIpFilter(const TCollection& rangeStrings) {
            for (const auto& rangeString : rangeStrings) {
                auto range = MakeRange(rangeString);
                const auto key = *range.Begin();

                if (Ranges.contains(key)) {
                    throw TIntersectedRangesException(range, Ranges.at(key));
                }

                Ranges.emplace(key, std::move(range));
            }

            for (auto current = Ranges.begin(); current != Ranges.end(); ++current) {
                const auto& next = std::next(current);

                if (next == Ranges.end()) {
                    break;
                }
                
                if (current->second.Overlaps(next->second)) {
                    throw TIntersectedRangesException(current->second, next->second);
                }
            }
        }

        bool IsPassing(const TStringBuf ipStr) const;

    private:
        static TIpAddressRange MakeRange(const TString& rangeString);

        TMap<TIpv6Address, TIpAddressRange> Ranges;
    };
}
