#include "ip_filter_exceptions.h"

namespace NCrypta {
    TIntersectedRangesException::TIntersectedRangesException(const TIpAddressRange& range1, const TIpAddressRange& range2)
    : Message{(TStringBuilder() << "Range intersection between " << range1.ToRangeString() << " and " << range2.ToRangeString())}
    {
    }

    const char* TIntersectedRangesException::TIntersectedRangesException::what() const noexcept {
        return Message.c_str();
    }

    IOutputStream& operator<<(IOutputStream& os, const TIntersectedRangesException& e) {
        os << e.what();
        return os;
    }
}
