#pragma once

#include <util/generic/yexception.h>
#include <library/cpp/ipmath/ipmath.h>

namespace NCrypta {
    class TIntersectedRangesException : public yexception {
    public:
        TIntersectedRangesException(const TIpAddressRange& range1, const TIpAddressRange& range2);
        const char* what() const noexcept;

        friend IOutputStream& operator<<(IOutputStream& os, const TIntersectedRangesException& e);

    private:
        TString Message;
    };
}
